//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.temporalrelation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstance;

// TODO: Auto-generated Javadoc
/**
 * <p>
 * The rule application result describes the result of applying a
 * {@link ITemporalRelationshipRule}. It contains a
 * {@link RuleApplicationStatus} and a list of all parent task instances and
 * tasks that were created during a rule application. See the description of
 * {@link ITemporalRelationshipRule} for more details.
 * </p>
 * 
 * @author Patrick Harms
 */
class RuleApplicationResult implements Serializable {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = -5927099713841481328L;

	/** The status. */
	private RuleApplicationStatus status = RuleApplicationStatus.NOT_APPLIED;

	/** The new parent tasks. */
	private final List<ITask> newParentTasks = new ArrayList<ITask>();

	/** The new parent instances. */
	private final List<ITaskInstance> newParentInstances = new ArrayList<ITaskInstance>();

	/**
	 * <p>
	 * create a rule application result with a status
	 * {@link RuleApplicationStatus#RULE_NOT_APPLIED}
	 * </p>.
	 */
	RuleApplicationResult() {
		// this is the default indicating nothing so far
	}

	/**
	 * <p>
	 * add a further parent task created during the rule application
	 * </p>.
	 *
	 * @param newParent the new parent
	 */
	void addNewlyCreatedTask(ITask newParent) {
		newParentTasks.add(newParent);
	}

	/**
	 * <p>
	 * add a further parent task instance created during the rule application
	 * </p>.
	 *
	 * @param newParent the new parent
	 */
	void addNewlyCreatedTaskInstance(ITaskInstance newParent) {
		newParentInstances.add(newParent);
	}

	/**
	 * <p>
	 * return all parent task instances created during the rule application
	 * </p>.
	 *
	 * @return the newly created task instances
	 */
	List<ITaskInstance> getNewlyCreatedTaskInstances() {
		return newParentInstances;
	}

	/**
	 * <p>
	 * return all parent tasks created during the rule application
	 * </p>.
	 *
	 * @return the newly created tasks
	 */
	List<ITask> getNewlyCreatedTasks() {
		return newParentTasks;
	}

	/**
	 * <p>
	 * return the rule application status
	 * </p>.
	 *
	 * @return the rule application status
	 */
	RuleApplicationStatus getRuleApplicationStatus() {
		return status;
	}

	/**
	 * <p>
	 * set the rule application status
	 * </p>.
	 *
	 * @param status the new rule application status
	 */
	void setRuleApplicationStatus(RuleApplicationStatus status) {
		this.status = status;
	}

}
