//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.html.guimodel;

import de.ugoe.cs.autoquest.eventcore.IEventTargetSpec;
import de.ugoe.cs.autoquest.eventcore.guimodel.AbstractDefaultGUIElement;

/**
 * <p>
 * Base class for all HTML GUI elements.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public abstract class HTMLGUIElement extends AbstractDefaultGUIElement {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;
    
    /**
     * <p>
     * the default distance value for different servers
     * </p>
     */
    protected static final double DISTANCE_DISTINCT_SERVER = 1.0;

    /**
     * <p>
     * the default distance value for same server but different documents
     * </p>
     */
    protected static final double DISTANCE_SAME_SERVER = 0.75;

    /**
     * <p>
     * the default distance value for same document but different page elements
     * </p>
     */
    protected static final double DISTANCE_SAME_DOCUMENT = 0.5;

    /**
     * <p>
     * the default distance value for same parent div but different page elements 
     * </p>
     */
    protected static final double DISTANCE_SAME_DIV = 0.2;

    /**
     * <p>
     * the default distance value for identical elements
     * </p>
     */
    protected static final double DISTANCE_NONE = 0.0;

    /**
     * <p>
     * Constructor. Creates a new HTMLGUIElement.
     * </p>
     * 
     * @param specification
     *            specification of created GUI element
     * @param parent
     *            parent of the created GUI element; null means that the element is a top-level
     *            window
     */
    public HTMLGUIElement(HTMLGUIElementSpec specification, HTMLGUIElement parent) {
        super(specification, parent);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.eventcore.IEventTarget#getPlatform()
     */
    @Override
    public String getPlatform() {
        return "HTML";
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return super.getSpecification().toString();
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement#updateSpecification(de.ugoe.cs.autoquest.eventcore
     * .guimodel.IGUIElementSpec)
     */
    @Override
    public void updateSpecification(IEventTargetSpec updateSpecification) {
        // nothing to do. There is no need for handle things such as name changes, etc.
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String getStringIdentifier() {
        String str = this.toString();
        if (getParent() != null) {
            return str + "<-" + getParent().getStringIdentifier();
        }
        return str;
    }

    /**
     * <p>
     * A short string describing the GUI element, e.g., Button, Canvas, or ScrollBar.
     * </p>
     * 
     * @return short element descriptor
     */
    protected String getElementDescriptor() {
        return "Default";
    }

}
