//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.eventcore.guimodel;

import de.ugoe.cs.autoquest.eventcore.AbstractDefaultHierarchicalEventTarget;

/**
 * <p>
 * Skeletal implementation for GUI elements.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public abstract class AbstractDefaultGUIElement extends AbstractDefaultHierarchicalEventTarget
    implements IGUIElement
{

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    public static final long serialVersionUID = 1L;
    
    /**
     * <p>
     * Boolean that indicates if a GUIElement was used during a session.
     * </p>
     */
    private boolean usageObserved;

    /**
     * <p>
     * Constructor. Creates a new AbstractDefaultGUIElement.
     * </p>
     * 
     * @param specification
     *            specification of the created GUI element
     * @param parent
     *            parent of the created GUI element; null means the element is a top-level window
     */
    public AbstractDefaultGUIElement(IGUIElementSpec specification, IGUIElement parent) {
        super(specification, parent);
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement#getGUIModel()
     */
    @Override
    public GUIModel getGUIModel() {
       return (GUIModel) super.getEventTargetModel();
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.eventcore.AbstractDefaultHierarchicalEventTarget#getParent()
     */
    @Override
    public IGUIElement getParent() {
        return (IGUIElement) super.getParent();
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.eventcore.AbstractDefaultHierarchicalEventTarget#getSpecification()
     */
    @Override
    public IGUIElementSpec getSpecification() {
        return (IGUIElementSpec) super.getSpecification();
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.eventcore.AbstractDefaultHierarchicalEventTarget#getEventTargetModel()
     */
    @Override
    public GUIModel getEventTargetModel() {
        return (GUIModel) super.getEventTargetModel();
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement#isUsed()
     */
    @Override
    public boolean isUsed() {
        return usageObserved;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement#markUsed()
     */
    @Override
    public void markUsed() {
        this.usageObserved = true;
    }

}
