//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.eventcore.guimodel;

import java.io.Serializable;
import java.util.List;

import de.ugoe.cs.autoquest.eventcore.HierarchicalEventTargetModel;

/**
 * <p>
 * A GUI model is a tree of {@link IGUIElements} and represents a complete GUI of a software. It is
 * platform independent. It may have several root nodes, as some GUIs are made up of several Frames
 * being independent from each other. The GUI model is filled using the
 * {@link #integratePath(List, de.ugoe.cs.autoquest.eventcore.IEventTargetFactory)} method.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms, Steffen Herbold
 */
public class GUIModel extends HierarchicalEventTargetModel<IGUIElement>
    implements Serializable
{

    /**  */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * instantiate a default unvalidated model
     * </p>
     *
     */
    public GUIModel() {
        super();
    }

    /**
     * <p>
     * instantiate a model that will validate itself internally if the provided parameters is set
     * to true. This is typically rather slow. 
     * </p>
     */
    public GUIModel(boolean validate) {
        super(validate);
    }

}
