/*
 * 
 */
package de.ugoe.cs.autoquest.tasktrees.alignment.algorithms;

import java.util.ArrayList;

import de.ugoe.cs.autoquest.tasktrees.alignment.matrix.SubstitutionMatrix;

// TODO: Auto-generated Javadoc
/**
 * The Interface AlignmentAlgorithm.
 */
public interface AlignmentAlgorithm {

	/**
	 * Align.
	 *
	 * @param input1 the input1
	 * @param input2 the input2
	 * @param submat the submat
	 * @param threshold the threshold
	 */
	void align(NumberSequence input1, NumberSequence input2,
			SubstitutionMatrix submat, float threshold);

	/**
	 * Gets the alignment.
	 *
	 * @return the alignment
	 */
	public abstract ArrayList<NumberSequence> getAlignment();

	/**
	 * Get the alignment score between the two input strings.
	 *
	 * @return the alignment score
	 */
	public abstract double getAlignmentScore();

	/**
	 * Gets the matches.
	 *
	 * @return the matches
	 */
	public abstract ArrayList<Match> getMatches();

	/**
	 * Gets the max score.
	 *
	 * @return the max score
	 */
	public double getMaxScore();

	/**
	 * Prints the alignment.
	 */
	public abstract void printAlignment();

	/**
	 * Prints the dp matrix.
	 */
	public abstract void printDPMatrix();

}