//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.genericeventmonitor;

/**
 * <p>
 * a message listener to be registered with the {@link GenericEventMonitorServer} for being called
 * for new messages containing events.
 * </p>
 * 
 * @author Patrick Harms
 */
public interface GenericEventMonitorMessageListener {

    /**
     * <p>
     * called for new received messages containing events. The client is described through the
     * <code>clientInfos</code>. The events are several events that were recorded at client side.
     * </p>
     *
     * @param clientInfos  infos about the client that send the events
     * @param events       the received events
     */
    void handleEvents(ClientInfos          clientInfos,
                      GenericEvent[]       events);

}
