//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.eventcore;

/**
 * <p>
 * Common interface for event target factories. They are used while constructing hierarchical
 * event target models.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public interface IEventTargetFactory {

    /**
     * <p>
     * Instantiates a new {@link IHierarchicalEventTarget} from a given specification.
     * </p>
     * 
     * @param specification
     *            specification of the new event target
     * @param parent
     *            parent of the new event target
     *            
     * @return created event target
     * 
     * @throws EventTargetModelConfigurationException
     *             thrown if there is a problem during the creation of the event target
     */
    public <T extends IHierarchicalEventTarget> T instantiateEventTarget(IEventTargetSpec specification,
                                                                         T                parent)
        throws EventTargetModelConfigurationException;

    /**
     * <p>
     * Instantiates a new {@link IHierarchicalEventTarget} that represents a group of event targets.
     * The returned object is defined to implement the interface but it must also derive from
     * {@link HierarchicalEventTargetGroup}. This is to ensure type consistency in an event target
     * model but to also allow simple group creations. 
     * </p>
     *
     * @param groupName                    the name of the group to be created
     * @param parent                       the parent element of the group
     * @param hierarchicalEventTargetModel the model to which the group will belong
     * @return
     */
    public <T extends IHierarchicalEventTarget> T instantiateGroup(String                          groupName,
                                                                   T                               parent,
                                                                   HierarchicalEventTargetModel<T> hierarchicalEventTargetModel);
    
}
