//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability;

import java.io.Serializable;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInfo;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;
import de.ugoe.cs.autoquest.tasktrees.treeifc.TaskMetric;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 16.07.2012$
 * @author 2012, last modified by $Author: pharms$
 */
public class UsabilitySmellIntensity implements Serializable {
    
    /**  */
    private static final long serialVersionUID = 1L;

    /** */
    private int ratio;
    
    /** */
    private int eventCoverage;
    
    /** */
    private int eventCoverageQuantile;

    /**
     * 
     */
    static UsabilitySmellIntensity getIntensity(int        ratio,
                                                ITask      taskWithSmell,
                                                ITaskModel wholeTaskModel)
    {
        ITaskInfo taskInfo = wholeTaskModel.getTaskInfo(taskWithSmell);
        int eventCoverage = taskInfo.getMeasureValue(TaskMetric.EVENT_COVERAGE);
        int eventCoverageQuantile = taskInfo.getMeasureValue(TaskMetric.EVENT_COVERAGE_QUANTILE);
        return getIntensity(ratio, eventCoverage, eventCoverageQuantile);
    }

    /**
     * 
     */
    static UsabilitySmellIntensity getIntensity(int ratio) {
        return getIntensity(ratio, -1, -1);
    }

    /**
     * 
     */
    static UsabilitySmellIntensity getIntensity(int ratio,
                                                int eventCoverage,
                                                int eventCoverageQuantile)
    {
        if ((ratio > 0) && ((eventCoverageQuantile == -1) || (eventCoverageQuantile > 0))) {
            return new UsabilitySmellIntensity(ratio, eventCoverage, eventCoverageQuantile);
        }
        else {
            return null;
        }
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param ratio
     * @param eventCoverage
     * @param eventCoverageQuantile
     */
    private UsabilitySmellIntensity(int ratio, int eventCoverage, int eventCoverageQuantile) {
        super();
        this.ratio = ratio;
        this.eventCoverage = eventCoverage;
        this.eventCoverageQuantile = eventCoverageQuantile;
    }

    /**
     * @return the ratio
     */
    public int getRatio() {
        return ratio;
    }

    /**
     * @return the eventCoverage
     */
    public int getEventCoverage() {
        return eventCoverage;
    }

    /**
     * @return the eventCoverageQuantile
     */
    public int getEventCoverageQuantile() {
        return eventCoverageQuantile;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return Integer.toString(ratio);
    }
    
}
