//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.taskequality;

import static org.junit.Assert.*;

import org.junit.Test;

import de.ugoe.cs.autoquest.eventcore.IEventTarget;
import de.ugoe.cs.autoquest.eventcore.IEventType;
import de.ugoe.cs.autoquest.eventcore.StringEventType;
import de.ugoe.cs.autoquest.tasktrees.taskequality.SelectionComparisonRule;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISelection;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.test.DummyGUIElement;

/**
 * @author Patrick Harms
 */
public class SelectionComparisonRuleTest extends AbstractComparisonRuleTest {

    /**
     *
     */
    @Test
    public void test_isApplicable_01() {
        SelectionComparisonRule rule = new SelectionComparisonRule();
        
        ITask task1 = createNewSelection();
        
        assertTrue(rule.isApplicable(task1, task1));
    }

    /**
     *
     */
    @Test
    public void test_isApplicable_02() {
        SelectionComparisonRule rule = new SelectionComparisonRule();

        ITask task1 = createNewSelection();
        ITask task2 = createNewSelection();
        
        assertTrue(rule.isApplicable(task1, task2));
        assertTrue(rule.isApplicable(task2, task1));
    }

    /**
     *
     */
    @Test
    public void test_isApplicable_03() {
        SelectionComparisonRule rule = new SelectionComparisonRule();

        ITask task1 = createNewSelection();
        ITask task2 = createNewSequence();
        
        assertFalse(rule.isApplicable(task1, task2));
        assertFalse(rule.isApplicable(task2, task1));
    }

    /**
     *
     */
    @Test
    public void test_isApplicable_04() {
        SelectionComparisonRule rule = new SelectionComparisonRule();

        ITask task1 = createNewSelection();
        ITask task2 = createNewIteration();
        
        assertFalse(rule.isApplicable(task1, task2));
        assertFalse(rule.isApplicable(task2, task1));
    }

    /**
     *
     */
    @Test
    public void test_isApplicable_05() {
        SelectionComparisonRule rule = new SelectionComparisonRule();

        ITask task1 = createNewSelection();
        ITask task2 = createNewOptional();
        
        assertFalse(rule.isApplicable(task1, task2));
        assertFalse(rule.isApplicable(task2, task1));
    }

    /**
     *
     */
    @Test
    public void test_isApplicable_06() {
        SelectionComparisonRule rule = new SelectionComparisonRule();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");

        ITask task1 = createNewSelection();
        ITask task2 = createNewEventTask(eventType1, eventTarget1);
        
        assertFalse(rule.isApplicable(task1, task2));
        assertFalse(rule.isApplicable(task2, task1));
    }

    /**
     * 
     */
    @Test
    public void test_compare_01() {
        SelectionComparisonRule rule = new SelectionComparisonRule();
        
        ISelection selection1 = createNewSelection();
        assertLexicallyEqual(rule, selection1, selection1);
    }

    /**
     * 
     */
    @Test
    public void test_compare_02() {
        SelectionComparisonRule rule = new SelectionComparisonRule();
        
        ISelection selection1 = createNewSelection();
        ISelection selection2 = createNewSelection();
        
        assertLexicallyEqual(rule, selection1, selection2);
    }

    /**
     * 
     */
    @Test
    public void test_compare_03() {
        SelectionComparisonRule rule = new SelectionComparisonRule();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");

        ITask task1 = createNewEventTask(eventType1, eventTarget1);
        
        ISelection selection1 = createNewSelection();
        ISelection selection2 = createNewSelection();
        
        addChild(selection1, task1);
        
        assertUnequal(rule, selection1, selection2);
    }

    /**
     * 
     */
    @Test
    public void test_compare_04() {
        SelectionComparisonRule rule = new SelectionComparisonRule();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");

        ITask task1 = createNewEventTask(eventType1, eventTarget1);
        
        ISelection selection1 = createNewSelection();
        ISelection selection2 = createNewSelection();
        
        addChild(selection1, task1);
        addChild(selection2, task1);
        
        assertLexicallyEqual(rule, selection1, selection2);
    }

    /**
     * 
     */
    @Test
    public void test_compare_05() {
        SelectionComparisonRule rule = new SelectionComparisonRule();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");

        IEventType eventType2 = new StringEventType("eventType2");
        IEventTarget eventTarget2 = new DummyGUIElement("elem2");

        ITask task1 = createNewEventTask(eventType1, eventTarget1);
        ITask task2 = createNewEventTask(eventType2, eventTarget2);
        
        ISelection selection1 = createNewSelection();
        ISelection selection2 = createNewSelection();
        
        addChild(selection1, task1);
        addChild(selection2, task2);
        
        assertUnequal(rule, selection1, selection2);
    }

    /**
     * 
     */
    @Test
    public void test_compare_06() {
        SelectionComparisonRule rule = new SelectionComparisonRule();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");

        IEventType eventType2 = new StringEventType("eventType2");
        IEventTarget eventTarget2 = new DummyGUIElement("elem2");

        ITask task1 = createNewEventTask(eventType1, eventTarget1);
        ITask task2 = createNewEventTask(eventType2, eventTarget2);
        
        ISelection selection1 = createNewSelection();
        ISelection selection2 = createNewSelection();
        
        addChild(selection1, task1);
        addChild(selection2, task2);
        
        ISelection selection3 = createNewSelection();
        addChild(selection3, task1);
        assertLexicallyEqual(rule, selection1, selection3);
        
        addChild(selection3, task2);
        assertLexicallyEqual(rule, selection2, selection3);
    }

}
