package de.ugoe.cs.eventbench.commands;

import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.List;

import de.ugoe.cs.eventbench.SequenceInstanceOf;
import de.ugoe.cs.eventbench.data.Event;
import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.models.TrieBasedModel;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to update a {@link TrieBasedModel}.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDupdateModel implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void run(List<Object> parameters) {
		String modelname;
		String sequencesName;

		try {
			modelname = (String) parameters.get(0);
			sequencesName = (String) parameters.get(1);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		Object dataObject = GlobalDataContainer.getInstance().getData(
				sequencesName);
		if (dataObject == null) {
			Console.println("Object " + sequencesName
					+ " not found in storage.");
			return;
		}
		if (!SequenceInstanceOf.isCollectionOfSequences(dataObject)) {
			Console.println("Object " + sequencesName
					+ "not of type Collection<List<Event<?>>>.");
			return;
		}
		Collection<List<Event<?>>> sequences = (Collection<List<Event<?>>>) dataObject;

		dataObject = GlobalDataContainer.getInstance().getData(modelname);
		if (dataObject == null) {
			Console.println("Object " + modelname + " not found in storage.");
			return;
		}
		if (!(dataObject instanceof TrieBasedModel)) {
			Console.println("Object " + modelname
					+ " not of type TrieBasedModel");
			return;
		}

		TrieBasedModel model = (TrieBasedModel) dataObject;
		model.update(sequences);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: updateModel <modelname> <sequencesName>");
	}

}
