//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.genericeventmonitor;

/**
 * <p>
 * represents infos of a client, e.g., its id
 * </p>
 * 
 * @author Patrick Harms
 */
class ClientInfos {

    /**
     * id of a client
     */
    private String clientId;

    /**
     * id of the app the client uses
     */
    private String appId;

    /**
     * <p>
     * instantiates an infos object with client id and an app id
     * </p>
     *
     * @param clientId  id of a client
     * @param appId  id of the app that the client uses
     */
    ClientInfos(String clientId, String appId) {
        this.clientId = clientId;
        this.appId = appId;
    }

    /**
     * @return the clientId
     */
    String getClientId() {
        return clientId;
    }

    /**
     * @return the appId
     */
    String getAppId() {
        return appId;
    }

}
