//   Copyright 2015 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.genericevents.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import de.ugoe.cs.autoquest.CommandHelpers;
import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Patrick Harms
 */
public class CMDparseDirSogouQData implements Command {

    /* (non-Javadoc)
     * @see de.ugoe.cs.util.console.Command#run(java.util.List)
     */
    @Override
    public void run(List<Object> parameters) {
        String path = null;
        String sequencesName = null;
        boolean hasTimestamp = false;
        boolean ignoreQuery = false;
        boolean compareDomainOnly = false;
        
        try {
            for (int i = 0; i < parameters.size(); i++) {
                String parameter = (String) parameters.get(i);
                if (!parameter.startsWith("-")) {
                    if (path == null) {
                        path = parameter;
                    }
                    else if (sequencesName == null) {
                        sequencesName = parameter;
                    }
                    else {
                        throw new IllegalArgumentException("unrecognized parameter: " + parameter);
                    }
                }
                else {
                    if ("-hasTimestamp".equals(parameter)) {
                        hasTimestamp = true;
                    }
                    else if ("-ignoreQuery".equals(parameter)) {
                        ignoreQuery = true;
                    }
                    else if ("-compareDomainOnly".equals(parameter)) {
                        compareDomainOnly = true;
                    }
                    else {
                        throw new IllegalArgumentException("unrecognized parameter: " + parameter);
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not process parameters", e);
        }
        
        if (path == null) {
            throw new IllegalArgumentException("no path to directory provided");
        }
        
        if (sequencesName == null) {
            sequencesName = "sequences";
        }

        File folder = new File(path);
        if (!folder.isDirectory()) {
            Console.printerrln(path + " is not a directory");
            return;
        }
        
        Map<String, List<Event>> userSessions = new HashMap<>();
        traverseFolder(folder, userSessions, hasTimestamp, ignoreQuery, compareDomainOnly);
        
        Collection<List<Event>> sequences = new ArrayList<>();
        
        for (List<Event> session : userSessions.values()) {
            if (session.size() > 1) {
                sequences.add(session);
            }
        }

        if (GlobalDataContainer.getInstance().addData(sequencesName, sequences)) {
            CommandHelpers.dataOverwritten(sequencesName);
        }
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param folder
     */
    private void traverseFolder(File folder, Map<String,
                                List<Event>> allUserSessions,
                                boolean      hasTimestamp,
                                boolean      ignoreQuery,
                                boolean      compareDomainOnly)
    {
        if (folder.isDirectory()) {
            for (File child : folder.listFiles()) {
                traverseFolder(child, allUserSessions, hasTimestamp, ignoreQuery, compareDomainOnly);
            }
        }
        else {
            Map<String, List<Event>> userSessions = new SogouQDataFileParser().parseFile
                (folder, hasTimestamp, ignoreQuery, compareDomainOnly);
            
            if (userSessions != null) {
                allUserSessions.putAll(userSessions);
            }
        }
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.util.console.Command#help()
     */
    @Override
    public String help() {
        return "parseDirSogouQData <folder> {<sequencesName>} {-hasTimestamp} {-ignoreQuery} " +
            "{-compareDomainOnly}";
    }

}
