//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.genericeventmonitor;

import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.TextConsole;

/**
 * <p>
 * implements the main method to start the {@link GenericEventMonitor}.
 * </p>
 * 
 * @author Patrick Harms
 * @version 1.0
 */
public class Runner {

    /**
     * <p>
     * Main method of the application.
     * </p>
     * 
     * @param args command line arguments
     */
    public static void main(String[] args) {
        new TextConsole();
        
        GenericEventMonitor monitor = new GenericEventMonitor(args);
        try {
            monitor.init();
        }
        catch (GenericEventMonitorException e) {
            Console.printerrln("could not initialize generic event monitor: " + e.getMessage());
            Console.logException(e);
        }
        
        monitor.start();
    }
}
