//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.jfc.guimodel;

import de.ugoe.cs.autoquest.eventcore.guimodel.GUIModel;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIView;

/**
 * <p>
 * A wrapper for JFC GUI elements which need to be considered a view. Usually, these are frames,
 * dialogs, and child panels of tabbed panes. The class delegates calls to the wrapped GUI element.
 * </p>
 * 
 * @author Patrick Harms
 */
public class JFCView implements IGUIView {

    /**  */
    private static final long serialVersionUID = 1L;
    
    /** */
    private JFCGUIElement delegate;
    
    /**
     * The default constructor taking the GUI element being the view as parameter
     */
    JFCView(JFCGUIElement delegate) {
        this.delegate = delegate;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.eventcore.guimodel.IGUIView#isModal()
     */
    @Override
    public boolean isModal() {
        return delegate instanceof JFCDialog;
    }

    /**
     * @return
     * @see de.ugoe.cs.autoquest.plugin.jfc.guimodel.JFCGUIElement#getPlatform()
     */
    public String getPlatform() {
        return delegate.getPlatform();
    }

    /**
     * @return
     * @see de.ugoe.cs.autoquest.eventcore.guimodel.AbstractDefaultGUIElement#getParent()
     */
    public IGUIElement getParent() {
        return delegate.getParent();
    }

    /**
     * @return
     * @see de.ugoe.cs.autoquest.eventcore.guimodel.AbstractDefaultGUIElement#getGUIModel()
     */
    public GUIModel getGUIModel() {
        return delegate.getGUIModel();
    }

    /**
     * @return
     * @see de.ugoe.cs.autoquest.plugin.jfc.guimodel.JFCGUIElement#getName()
     */
    public String getName() {
        return delegate.getName();
    }

    /**
     * @param other
     * @return
     * @see de.ugoe.cs.autoquest.eventcore.guimodel.AbstractDefaultGUIElement#equals(java.lang.Object)
     */
    public final boolean equals(Object other) {
        if (other instanceof JFCView) {
            return delegate.equals(((JFCView) other).delegate);
        }
        else {
            return false;
        }
    }

    /**
     * @return
     * @see de.ugoe.cs.autoquest.eventcore.guimodel.AbstractDefaultGUIElement#hashCode()
     */
    public final int hashCode() {
        return delegate.hashCode();
    }

    /**
     * @return
     * @see de.ugoe.cs.autoquest.plugin.jfc.guimodel.JFCGUIElement#toString()
     */
    public String toString() {
        return delegate.toString();
    }

}
