//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.eventcore;

/**
 * <p>
 * A simple event type that is identified by a string.
 * </p>
 * 
 * @version $Revision: $ $Date: Aug 16, 2012$
 * @author 2012, last modified by $Author: sherbold$
 */
public class StringEventType implements IEventType {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * String that identifies the event type.
     * </p>
     */
    private String str;

    /**
     * <p>
     * Constructor. Creates a new StringEventType. str must not be null.
     * </p>
     * 
     * @param str
     *            string that identifies the event type
     * @throws IllegalArgumentException
     *             thrown if str is null
     */
    public StringEventType(String str) throws IllegalArgumentException {
        if (str == null) {
            throw new IllegalArgumentException("str must not be null");
        }
        this.str = str;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.eventcore.IEventType#getName()
     */
    @Override
    public String getName() {
        return str;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return str;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return str.hashCode();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof StringEventType) {
            return str.equals(((StringEventType) other).str);
        }
        return false;
    }
}
