//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.httpmonitor;

import dummyservice.DummyServicePortTypeImpl;
import dummyservice.SynStatus;
import dummyservice.UserInfo;
import dummyservice.VerifyUserInMsgType;
import dummyservice.VerifyUserOutMsgType;

/**
 * <p>
 * Dummy implementation of a SOAP service for testing
 * </p>
 * 
 * @author Patrick Harms
 */
public class DummyServiceImpl extends DummyServicePortTypeImpl {

    /* (non-Javadoc)
     * @see eu.midas_project.enduser.api.identityandauthenticationservice_wsdl.IdentityAndAuthPortTypeImpl#verifyUser(eu.midas_project.enduser.api.identityandauthenticationtypes.VerifyUserInMsgType)
     */
    @Override
    public VerifyUserOutMsgType verifyUser(VerifyUserInMsgType content) {
        System.out.println("DummyServiceImpl.verifyUser");

        VerifyUserOutMsgType result = new VerifyUserOutMsgType();
        result.setMsg("OK");
        result.setStatus(SynStatus.DONE);
        UserInfo userInfo = new UserInfo();
        userInfo.setUsername("dummyUser");
        userInfo.setIsAdmin(true);
        userInfo.setFullname("Dummy User");
        userInfo.setEmail("dummy.user@midas_project.eu");
        result.setUserInfo(userInfo);
        return result;
    }

}
