//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.eventcore;

import java.io.Serializable;

import de.ugoe.cs.autoquest.IReplayDecorator;

/**
 * <p>
 * This interface is used by {@link ReplayableEvent}to describe how events can
 * be replayed. It can be used to define a sequence of fine-grained platform
 * events that make up an abstract event.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public interface IReplayable extends Serializable {

	/**
	 * <p>
	 * Returns a string to be written to the replay script that describes the
	 * replayable platform event.
	 * </p>
	 * 
	 * @return string for the replay script
	 */
	String getReplay();
	
	/**
	 * <p>
	 * Returns the replay decorator associated with the replayable. Returns null if no replay decorator is associated with the replayable.
	 * </p>
	 *
	 * @return replay decorator
	 */
	IReplayDecorator getDecorator();
}
