//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.temporalrelation;

import org.junit.Test;

/**
 * @author Patrick Harms
 */
public class SequenceForTaskDetectionRuleTest extends AbstractTemporalRelationshipTC {

    /**
     *
     */
    @Test
    public void test_TaskDetection_01() throws Exception {
        String input =
            "UserSession {" +
            "  Event noise0 {}" +
            "  Event action1 {}" +
            "  Event action2 {}" +
            "  Event action3 {}" +
            "  Event action4 {}" +
            "  Event noise1 {}" +
            "  Event noise2 {}" +
            "  Event action1 {}" +
            "  Event action2 {}" +
            "  Event action3 {}" +
            "  Event action4 {}" +
            "  Event noise3 {}" +
            "  Event noise4 {}" +
            "  Event noise5 {}" +
            "  Event noise6 {}" +
            "  Event action1 {}" +
            "  Event action2 {}" +
            "  Event action3 {}" +
            "  Event action4 {}" +
            "  Event action1 {}" +
            "  Event action2 {}" +
            "  Event action3 {}" +
            "  Event action4 {}" +
            "  Event noise7 {}" +
            "}";

        String output =
            "UserSession {" +
            "  Event noise0 {}" +
            "  Iteration iteration1 {" +
            "    Sequence sequence1 {" +
            "      Event action1 {}" +
            "      Event action2 {}" +
            "      Event action3 {}" +
            "      Event action4 {}" +
            "    }" +
            "  }" +
            "  Event noise1 {}" +
            "  Event noise2 {}" +
            "  Iteration iteration1 {" +
            "    Sequence sequence1 {" +
            "      Event action1 {}" +
            "      Event action2 {}" +
            "      Event action3 {}" +
            "      Event action4 {}" +
            "    }" +
            "  }" +
            "  Event noise3 {}" +
            "  Event noise4 {}" +
            "  Event noise5 {}" +
            "  Event noise6 {}" +
            "  Iteration iteration1 {" +
            "    Sequence sequence1 {" +
            "      Event action1 {}" +
            "      Event action2 {}" +
            "      Event action3 {}" +
            "      Event action4 {}" +
            "    }" +
            "    Sequence sequence1 {" +
            "      Event action1 {}" +
            "      Event action2 {}" +
            "      Event action3 {}" +
            "      Event action4 {}" +
            "    }" +
            "  }" +
            "  Event noise7 {}" +
            "}";

        applySessionScopeRule(SequenceForTaskDetectionRule.class, input, output);
    }

    /**
     *
     */
    @Test
    public void test_TaskDetection_02() throws Exception {
        String input =
            "UserSession {" +
            "  Event noise0 {}" +
            "  Event action1 {}" +
            "  Event action2 {}" +
            "  Event noise1 {}" +
            "  Event noise2 {}" +
            "  Event action3 {}" +
            "  Event action1 {}" +
            "  Event action2 {}" +
            "  Event action4 {}" +
            "  Event noise3 {}" +
            "  Event noise4 {}" +
            "  Event noise5 {}" +
            "  Event noise6 {}" +
            "  Event action1 {}" +
            "  Event action2 {}" +
            "  Event action3 {}" +
            "  Event action4 {}" +
            "  Event action1 {}" +
            "  Event action2 {}" +
            "  Event action3 {}" +
            "  Event action4 {}" +
            "  Event noise7 {}" +
            "}";

        String output =
            "UserSession {" +
            "  Event noise0 {}" +
            "  Sequence sequence1 {" +
            "    Event action1 {}" +
            "    Event action2 {}" +
            "  }" +
            "  Event noise1 {}" +
            "  Event noise2 {}" +
            "  Event action3 {}" +
            "  Sequence sequence1 {" +
            "    Event action1 {}" +
            "    Event action2 {}" +
            "  }" +
            "  Event action4 {}" +
            "  Event noise3 {}" +
            "  Event noise4 {}" +
            "  Event noise5 {}" +
            "  Event noise6 {}" +
            "  Iteration iteration1 {" +
            "    Sequence sequence3 {" +
            "      Sequence sequence1 {" +
            "        Event action1 {}" +
            "        Event action2 {}" +
            "      }" +
            "      Event action3 {}" +
            "      Event action4 {}" +
            "    }" +
            "    Sequence sequence3 {" +
            "      Sequence sequence1 {" +
            "        Event action1 {}" +
            "        Event action2 {}" +
            "      }" +
            "      Event action3 {}" +
            "      Event action4 {}" +
            "    }" +
            "  }" +
            "  Event noise7 {}" +
            "}";

        applySessionScopeRule(SequenceForTaskDetectionRule.class, input, output);
    }

    /**
     *
     */
    @Test
    public void test_TaskDetection_03() throws Exception {
        String input =
            "UserSession {" +
            "  Event noise0 {}" +
            "  Event a {}" +
            "  Event b {}" +
            "  Event c {}" +
            "  Event noise1 {}" +
            "  Event a {}" +
            "  Event b {}" +
            "  Event noise2 {}" +
            "  Event b {}" +
            "  Event c {}" +
            "  Event noise3 {}" +
            "  Event a {}" +
            "  Event b {}" +
            "  Event noise4 {}" +
            "  Event b {}" +
            "  Event c {}" +
            "  Event noise5 {}" +
            "}";

        String output =
            "UserSession {" +
            "  Event noise0 {}" +
            "  Sequence sequence1 {" +
            "    Event a {}" +
            "    Event b {}" +
            "  }" +
            "  Event c {}" +
            "  Event noise1 {}" +
            "  Sequence sequence1 {" +
            "    Event a {}" +
            "    Event b {}" +
            "  }" +
            "  Event noise2 {}" +
            "  Sequence sequence2 {" +
            "    Event b {}" +
            "    Event c {}" +
            "  }" +
            "  Event noise3 {}" +
            "  Sequence sequence1 {" +
            "    Event a {}" +
            "    Event b {}" +
            "  }" +
            "  Event noise4 {}" +
            "  Sequence sequence2 {" +
            "    Event b {}" +
            "    Event c {}" +
            "  }" +
            "  Event noise5 {}" +
            "}";

        applySessionScopeRule(SequenceForTaskDetectionRule.class, input, output);
    }

    /**
     *
     */
    @Test
    public void test_TaskDetection_04() throws Exception {
        String input =
            "UserSession {" +
            "  Event noise0 {}" +
            "  Event a {}" +
            "  Event b {}" +
            "  Event a {}" +
            "  Event noise1 {}" +
            "  Event a {}" +
            "  Event b {}" +
            "  Event noise2 {}" +
            "  Event b {}" +
            "  Event a {}" +
            "  Event noise3 {}" +
            "  Event a {}" +
            "  Event b {}" +
            "  Event noise4 {}" +
            "  Event b {}" +
            "  Event a {}" +
            "  Event noise5 {}" +
            "}";

        String output =
            "UserSession {" +
            "  Event noise0 {}" +
            "  Sequence sequence1 {" +
            "    Event a {}" +
            "    Event b {}" +
            "  }" +
            "  Event a {}" +
            "  Event noise1 {}" +
            "  Sequence sequence1 {" +
            "    Event a {}" +
            "    Event b {}" +
            "  }" +
            "  Event noise2 {}" +
            "  Sequence sequence2 {" +
            "    Event b {}" +
            "    Event a {}" +
            "  }" +
            "  Event noise3 {}" +
            "  Sequence sequence1 {" +
            "    Event a {}" +
            "    Event b {}" +
            "  }" +
            "  Event noise4 {}" +
            "  Sequence sequence2 {" +
            "    Event b {}" +
            "    Event a {}" +
            "  }" +
            "  Event noise5 {}" +
            "}";

        applySessionScopeRule(SequenceForTaskDetectionRule.class, input, output);
    }

    /**
     *
     */
    @Test
    public void test_TaskDetection_05() throws Exception {
        String input =
            "UserSession {" +
            "  Event noise0 {}" +
            "  Event a {}" +
            "  Event b {}" +
            "  Event a {}" +
            "  Event noise1 {}" +
            "  Event b {}" +
            "  Event a {}" +
            "  Event b {}" +
            "  Event noise2 {}" +
            "  Event b {}" +
            "  Event a {}" +
            "  Event c {}" +
            "  Event noise2 {}" +
            "  Event a {}" +
            "  Event b {}" +
            "  Event noise3 {}" +
            "  Event a {}" +
            "  Event c {}" +
            "  Event noise4 {}" +
            "  Event a {}" +
            "  Event c {}" +
            "}";

        String output =
            "UserSession {" +
            "  Event noise0 {}" +
            "  Sequence 1 {" +
            "    Event a {}" +
            "    Event b {}" +
            "  }" +
            "  Event a {}" +
            "  Event noise1 {}" +
            "  Event b {}" +
            "  Sequence 1 {" +
            "    Event a {}" +
            "    Event b {}" +
            "  }" +
            "  Event noise2 {}" +
            "  Event b {}" +
            "  Sequence 2 {" +
            "    Event a {}" +
            "    Event c {}" +
            "  }" +
            "  Event noise2 {}" +
            "  Sequence 1 {" +
            "    Event a {}" +
            "    Event b {}" +
            "  }" +
            "  Event noise3 {}" +
            "  Sequence 2 {" +
            "    Event a {}" +
            "    Event c {}" +
            "  }" +
            "  Event noise4 {}" +
            "  Sequence 2 {" +
            "    Event a {}" +
            "    Event c {}" +
            "  }" +
            "}";

        applySessionScopeRule(SequenceForTaskDetectionRule.class, input, output);
    }

    /**
     *
     */
    @Test
    public void test_TaskDetection_06() throws Exception {
        String input =
            "UserSession {" +
            "  Event noise0 {}" +
            "  Event a {}" +
            "  Event b {}" +
            "  Event a {}" +
            "  Event noise1 {}" +
            "  Event b {}" +
            "  Event a {}" +
            "  Event b {}" +
            "  Event noise2 {}" +
            "  Event a {}" +
            "  Event b {}" +
            "  Event a {}" +
            "}";

        String output =
            "UserSession {" +
            "  Event noise0 {}" +
            "  Sequence 1 {" +
            "    Sequence 2 {" +
            "      Event a {}" +
            "      Event b {}" +
            "    }" +
            "    Event a {}" +
            "  }" +
            "  Event noise1 {}" +
            "  Event b {}" +
            "  Sequence 2 {" +
            "    Event a {}" +
            "    Event b {}" +
            "  }" +
            "  Event noise2 {}" +
            "  Sequence 1 {" +
            "    Sequence 2 {" +
            "      Event a {}" +
            "      Event b {}" +
            "    }" +
            "    Event a {}" +
            "  }" +
            "}";

        applySessionScopeRule(SequenceForTaskDetectionRule.class, input, output);
    }

    /**
     *
     */
    @Test
    public void test_TaskDetection_07() throws Exception {
        String input =
            "UserSession {" +
            "  Event noise0 {}" +
            "  Event a {}" +
            "  Event b {}" +
            "  Event c {}" +
            "  Event noise1 {}" +
            "  Event b {}" +
            "  Event c {}" +
            "  Event a {}" +
            "  Event noise2 {}" +
            "  Event c {}" +
            "  Event a {}" +
            "  Event b {}" +
            "}";

        String output =
            "UserSession {" +
            "  Event noise0 {}" +
            "  Event a {}" +
            "  Sequence 1 {" +
            "    Event b {}" +
            "    Event c {}" +
            "  }" +
            "  Event noise1 {}" +
            "  Sequence 1 {" +
            "    Event b {}" +
            "    Event c {}" +
            "  }" +
            "  Event a {}" +
            "  Event noise2 {}" +
            "  Event c {}" +
            "  Event a {}" +
            "  Event b {}" +
            "}";

        applySessionScopeRule(SequenceForTaskDetectionRule.class, input, output);
    }

    /**
     *
     */
    @Test
    public void test_TaskDetection_08() throws Exception {
        String input =
            "UserSession {" +
            "  Event noise0 {}" +
            "  Event a {}" +
            "  Event b {}" +
            "  Event c {}" +
            "  Event noise1 {}" +
            "  Event a {}" +
            "  Event b {}" +
            "  Event d {}" +
            "  Event noise2 {}" +
            "  Event a {}" +
            "  Event b {}" +
            "  Event e {}" +
            "  Event noise3 {}" +
            "  Event b {}" +
            "  Event c {}" +
            "  Event d {}" +
            "  Event noise4 {}" +
            "  Event b {}" +
            "  Event d {}" +
            "  Event e {}" +
            "  Event noise5 {}" +
            "  Event b {}" +
            "  Event d {}" +
            "  Event f {}" +
            "  Event noise6 {}" +
            "  Event a {}" +
            "  Event b {}" +
            "  Event noise7 {}" +
            "  Event b {}" +
            "  Event c {}" +
            "  Event noise8 {}" +
            "  Event b {}" +
            "  Event d {}" +
            "  Event noise9 {}" +
            "}";

        String output =
            "UserSession {" +
            "  Event noise0 {}" +
            "  Sequence 1 {" +
            "    Event a {}" +
            "    Event b {}" +
            "  }" +
            "  Event c {}" +
            "  Event noise1 {}" +
            "  Sequence 1 {" +
            "    Event a {}" +
            "    Event b {}" +
            "  }" +
            "  Event d {}" +
            "  Event noise2 {}" +
            "  Sequence 1 {" +
            "    Event a {}" +
            "    Event b {}" +
            "  }" +
            "  Event e {}" +
            "  Event noise3 {}" +
            "  Sequence 2 {" +
            "    Event b {}" +
            "    Event c {}" +
            "  }" +
            "  Event d {}" +
            "  Event noise4 {}" +
            "  Sequence 3 {" +
            "    Event b {}" +
            "    Event d {}" +
            "  }" +
            "  Event e {}" +
            "  Event noise5 {}" +
            "  Sequence 3 {" +
            "    Event b {}" +
            "    Event d {}" +
            "  }" +
            "  Event f {}" +
            "  Event noise6 {}" +
            "  Sequence 1 {" +
            "    Event a {}" +
            "    Event b {}" +
            "  }" +
            "  Event noise7 {}" +
            "  Sequence 2 {" +
            "    Event b {}" +
            "    Event c {}" +
            "  }" +
            "  Event noise8 {}" +
            "  Sequence 3 {" +
            "    Event b {}" +
            "    Event d {}" +
            "  }" +
            "  Event noise9 {}" +
            "}";

        applySessionScopeRule(SequenceForTaskDetectionRule.class, input, output);
    }
}
