//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeifc;

/**
 * <p>
 * Default implementation for a task visitor performing a traversal of the task
 * </p>
 * 
 * @author Patrick Harms
 */
public class DefaultTaskTraversingVisitor implements ITaskVisitor {

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskVisitor#visit(IEventTask)
     */
    @Override
    public void visit(IEventTask eventTask) {
        // do nothing
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskVisitor#visit(IIteration)
     */
    @Override
    public void visit(IIteration iteration) {
        visit((IMarkingTemporalRelationship) iteration);
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskVisitor#visit(IOptional)
     */
    @Override
    public void visit(IOptional optional) {
        visit((IMarkingTemporalRelationship) optional);
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskVisitor#visit(ISelection)
     */
    @Override
    public void visit(ISelection selection) {
        visit((IStructuringTemporalRelationship) selection);
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskVisitor#visit(ISequence)
     */
    @Override
    public void visit(ISequence sequence) {
        visit((IStructuringTemporalRelationship) sequence);
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskVisitor#visit(ITask)
     */
    @Override
    public void visit(ITask task) {
        if (task instanceof IEventTask) {
            visit((IEventTask) task);
        }
        else if (task instanceof IIteration) {
            visit((IIteration) task);
        }
        else if (task instanceof IOptional) {
            visit((IOptional) task);
        }
        else if (task instanceof ISelection) {
            visit((ISelection) task);
        }
        else if (task instanceof ISequence) {
            visit((ISequence) task);
        }
    }

    /**
     * <p>
     * common implementation for traversing a structuring temporal relationship 
     * </p>
     * 
     * @param relationship the structuring temporal relationship to be traversed
     */
    public void visit(IStructuringTemporalRelationship relationship) {
        for (ITask child : relationship.getChildren()) {
            child.accept(this);
        }
    }

    /**
     * <p>
     * common implementation for traversing a marking temporal relationship 
     * </p>
     * 
     * @param relationship the marking temporal relationship to be traversed
     */
    public void visit(IMarkingTemporalRelationship relationship) {
        if (relationship.getMarkedTask() != null) {
            relationship.getMarkedTask().accept(this);
        }
    }
}
