//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin;

/**
 * <p>
 * This exception is thrown in case there is an error during the loading of
 * AutoQUEST plugins. Note that the failures during the loading may result in an
 * invalid classpath and this exception should, therefore, be treated with
 * appropriate care.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class PluginLoaderException extends RuntimeException {

	/**
	 * @see RuntimeException#RuntimeException(String)
	 */
	public PluginLoaderException(String msg) {
		super(msg);
	}
	
	/**
	 * @see RuntimeException#RuntimeException(Throwable)
	 */
	public PluginLoaderException(Throwable throwable) {
		super(throwable);
	}

	/**
	 * <p>
	 * Id for object serialization.
	 * </p>
	 */
	private static final long serialVersionUID = 1L;

}
