//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.mfc.commands;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;

import de.ugoe.cs.autoquest.plugin.mfc.LogPreprocessor;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to pre-process a single file.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDconvertToXml implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public String help() {
		return "convertToXml <sourceFile> <targetFile> {<base64>}";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		if (parameters.size() < 2) {
			throw new IllegalArgumentException();
		}
		String source = (String) parameters.get(0);
		String target = (String) parameters.get(1);
		boolean base64 = false;
		if (parameters.size() == 3) {
			base64 = Boolean.parseBoolean((String) parameters.get(2));
		}

		try {
			new LogPreprocessor(base64).convertToXml(source, target);
		} catch (FileNotFoundException e) {
			Console.printerrln(e.getMessage());
		} catch (IOException e) {
			Console.printerrln(e.getMessage());
		}

	}

}
