//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.uml.eventcore;

import org.eclipse.uml2.uml.Transition;

import de.ugoe.cs.autoquest.eventcore.IEventType;

/**
 * <p>
 * Event type for transitions in UML sequence diagrams
 * </p>
 * 
 * @author Steffen Herbold
 */
public class UMLTransitionType implements IEventType {

    /**
     * Id for object serialization.
     */
    private static final long serialVersionUID = 1L;

    /**
     * associated UML transition
     */
    private final Transition transition;

    /**
     * <p>
     * Constructor. Creates a new instance.
     * </p>
     * 
     * @param transition
     *            the instance
     */
    public UMLTransitionType(Transition transition) {
        if (transition == null) {
            throw new IllegalArgumentException("Transition must not be null");
        }
        this.transition = transition;
    }

    /**
     * <p>
     * Returns the associated UML element
     * </p>
     * 
     * @return
     */
    public Transition getTransition() {
        return transition;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof UMLTransitionType) {
            return ((UMLTransitionType) other).transition.equals(transition);
        }
        return false;
    };

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return transition.hashCode();
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.eventcore.IEventType#getName()
     */
    @Override
    public String getName() {
        return transition.getName();
    }

}
