/**
 * 
 */
package de.ugoe.cs.autoquest.plugin.alignment.substitution;

import java.util.Collection;
import java.util.List;

import de.ugoe.cs.autoquest.eventcore.Event;

/**
 * @author Ralph Krimmel
 *
 */
public class DifferenceSubstitutionMatrix implements SubstitutionMatrix {

	private int[] input1;
	private int[] input2;
	private int maxValue;
	
	public DifferenceSubstitutionMatrix(int[] input1,int[] input2) {
		this.input1 = input1;
		this.input2 = input2;
		this.maxValue = getMaxValue();
	}
	
	/* (non-Javadoc)
	 * @see de.ugoe.cs.autoquest.plugin.alignment.SubstitutionMatrix#getDistance(int, int)
	 */
	public double getDistance(int pos1, int pos2) {
		return maxValue - (input1[pos1] - input2[pos2]);
	}
	
	private int getMaxValue() {
		int max = input1[0];
		for (int i=0; i < input1.length; i++) {
			if(input1[i] > max) {
				max = input1[i];
			}
		}
		for (int j=0; j < input2.length; j++) {
			if(input2[j] > max) {
				max = input2[j];
			}
		}
		return max;
	}

	@Override
	public double getGapPenalty() {
		return -maxValue;
	}

	@Override
	public String info() {
		return "Max Value: " + maxValue;
	}

	@Override
	public void generate(Collection<List<Event>> eventList) {
		// TODO Auto-generated method stub
		
	}

}
