//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.util.console.defaultcommands;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;

import org.apache.commons.lang.WordUtils;

import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.CommandExecuter;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Prints the manual of a command to the Console.
 * </p>
 * 
 * @version $Revision: $ $Date: Aug 30, 2012$
 * @author 2012, last modified by $Author: sherbold$
 */
public class CMDman implements Command {

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#run(java.util.List)
     */
    @Override
    public void run(List<Object> parameters) {
        String command;
        if (parameters.size() > 0) {
            command = (String) parameters.get(0);
        }
        else {
            throw new IllegalArgumentException();
        }

        Command cmd = CommandExecuter.getInstance().getCMD(command);

        if (cmd != null) {
            InputStream manStream =
                ClassLoader.getSystemResourceAsStream("manuals/" + command);
            
            if (manStream != null) {
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(manStream, "UTF-8"));
                    String line = reader.readLine();
                    
                    while (line != null) {
                        line = line.replace("$USAGE$", "Usage: " + cmd.help());
                        Console.println(WordUtils.wrap(line, 100));
                        line = reader.readLine();
                    }
                }
                catch (IOException e) {
                    Console.printerrln("Failure reading man page");
                    Console.logException(e);
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException e) {
                        // Ignore, as this is unimportant to the user
                    }
                }
            }
            else {
                Console.println("No man page for command " + command + " available");
            }
        }
        else {
            Console.println("Command " + command + " not found.");
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#help()
     */
    @Override
    public String help() {
        return "man <commandName>";
    }

}
