/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.guitar.model;

import edu.umd.cs.guitar.event.GEvent;
import edu.umd.cs.guitar.model.GObject;
import edu.umd.cs.guitar.model.GWindow;
import edu.umd.cs.guitar.model.data.AttributesType;
import edu.umd.cs.guitar.model.data.ComponentType;
import edu.umd.cs.guitar.model.data.ContainerType;
import edu.umd.cs.guitar.model.data.ContentsType;
import edu.umd.cs.guitar.model.data.PropertyType;
import edu.umd.cs.guitar.model.wrapper.ComponentTypeWrapper;
import edu.umd.cs.guitar.model.wrapper.PropertyTypeWrapper;
import java.util.ArrayList;
import java.util.List;

public abstract class GComponent
implements GObject {
    private static int ID_COUNTER = 0;
    private int ID;
    GWindow window;

    public GComponent(GWindow window) {
        this.window = window;
        this.ID = ID_COUNTER++;
    }

    public ComponentType extractProperties() {
        ComponentType retComp;
        if (!this.hasChildren()) {
            retComp = factory.createComponentType();
        } else {
            retComp = factory.createContainerType();
            ContentsType contents = factory.createContentsType();
            ((ContainerType)retComp).setContents(contents);
        }
        ComponentTypeWrapper retCompAdapter = new ComponentTypeWrapper(retComp);
        String sClass = this.getClassVal();
        retCompAdapter.addValueByName("Class", sClass);
        String sType = this.getTypeVal();
        retCompAdapter.addValueByName("Type", sType);
        int x = this.getX();
        retCompAdapter.addValueByName("X", Integer.toString(x));
        int y = this.getY();
        retCompAdapter.addValueByName("Y", Integer.toString(y));
        List<GEvent> lEvents = this.getEventList();
        for (GEvent event : lEvents) {
            retCompAdapter.addValueByName("ReplayableAction", event.getClass().getName());
        }
        retComp = retCompAdapter.getDComponentType();
        AttributesType attributes = retComp.getAttributes();
        List<PropertyType> lProperties = attributes.getProperty();
        List<PropertyType> lGUIProperties = this.getGUIProperties();
        if (lGUIProperties != null) {
            lProperties.addAll(lGUIProperties);
        }
        attributes.setProperty(lProperties);
        retComp.setAttributes(attributes);
        return retComp;
    }

    public int hashCode() {
        List<PropertyType> guiProperties = this.getGUIProperties();
        int prime = 31;
        int result = 1;
        if (guiProperties == null) {
            return 0;
        }
        for (PropertyType property : guiProperties) {
            String name = property.getName();
            result = 31 * result + (name == null ? 0 : name.hashCode());
            result = Math.abs(result);
            List<String> valueList = property.getValue();
            result = 31 * result + (valueList == null ? 0 : ((Object)valueList).hashCode());
            result = Math.abs(result);
        }
        return result;
    }

    public abstract String getClassVal();

    public abstract List<GEvent> getEventList();

    public abstract List<GComponent> getChildren();

    public abstract GComponent getParent();

    public abstract String getTypeVal();

    public abstract boolean hasChildren();

    public abstract boolean isTerminal();

    public abstract boolean isEnable();

    public GComponent getFirstChild(List<PropertyTypeWrapper> lIDProperties) {
        ComponentType comp = this.extractProperties();
        List<PropertyType> lProperties = comp.getAttributes().getProperty();
        ArrayList<PropertyTypeWrapper> lPropertyTypeAdapters = new ArrayList<PropertyTypeWrapper>();
        for (PropertyType p : lProperties) {
            lPropertyTypeAdapters.add(new PropertyTypeWrapper(p));
        }
        if (lPropertyTypeAdapters.containsAll(lIDProperties)) {
            return this;
        }
        List<GComponent> gChildren = this.getChildren();
        GComponent result = null;
        for (GComponent gChild : gChildren) {
            result = gChild.getFirstChild(lIDProperties);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public GComponent getChildByPropertySet(List<PropertyType> properties) {
        List<GComponent> gChildren = this.getChildren();
        GComponent result = null;
        for (GComponent gChild : gChildren) {
            result = gChild.getChildByPropertySet(properties);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

