/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.guitar.model.wrapper;

import edu.umd.cs.guitar.model.GHashcodeGenerator;
import edu.umd.cs.guitar.model.data.AttributesType;
import edu.umd.cs.guitar.model.data.ComponentType;
import edu.umd.cs.guitar.model.data.ContainerType;
import edu.umd.cs.guitar.model.data.ContentsType;
import edu.umd.cs.guitar.model.data.EventType;
import edu.umd.cs.guitar.model.data.GUIStructure;
import edu.umd.cs.guitar.model.data.ObjectFactory;
import edu.umd.cs.guitar.model.data.PropertyType;
import edu.umd.cs.guitar.model.wrapper.AttributesTypeWrapper;
import edu.umd.cs.guitar.model.wrapper.GUIStructureWrapper;
import edu.umd.cs.guitar.model.wrapper.GUITypeWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ComponentTypeWrapper {
    ComponentType dComponentType;
    GUITypeWrapper window;
    List<GUITypeWrapper> invokedWindows;
    ComponentTypeWrapper parent;
    List<ComponentTypeWrapper> children;
    static ObjectFactory factory = new ObjectFactory();
    static int ID_COUNTER = 0;
    private static final String EVENT_ID_SPLITTER = "_";

    public List<GUITypeWrapper> getInvokedWindows() {
        return this.invokedWindows;
    }

    public void parseData(GUIStructure dGUIStructure, GUIStructureWrapper wGUIStructure) {
        List<ComponentType> dChildrenList;
        List<String> sInvokeList = this.getValueListByName("Invokelist");
        if (sInvokeList != null) {
            this.invokedWindows = new ArrayList<GUITypeWrapper>();
            for (String invokedWinTitle : sInvokeList) {
                GUITypeWrapper invokedWin = wGUIStructure.getGUIByTitle(invokedWinTitle);
                if (invokedWin == null || invokedWin.equals(this.getWindow().getTitle()) || invokedWin == null) continue;
                this.invokedWindows.add(invokedWin);
                invokedWin.setInvoker(this);
                invokedWin.getInvokerList().add(this);
                List<GUITypeWrapper> lGUIs = wGUIStructure.getGUIs();
                if (lGUIs.contains(invokedWin)) continue;
                wGUIStructure.getGUIs().add(invokedWin);
                invokedWin.parseData(dGUIStructure, wGUIStructure);
            }
        }
        if (this.dComponentType instanceof ContainerType && (dChildrenList = ((ContainerType)this.dComponentType).getContents().getWidgetOrContainer()) != null) {
            this.children = new ArrayList<ComponentTypeWrapper>();
            for (ComponentType dChild : dChildrenList) {
                ComponentTypeWrapper wChild = new ComponentTypeWrapper(dChild);
                wChild.setParent(this);
                wChild.setWindow(this.window);
                wChild.parseData(dGUIStructure, wGUIStructure);
                this.children.add(wChild);
            }
        }
    }

    public void parseData() {
        List<ComponentType> dChildrenList;
        if (this.dComponentType instanceof ContainerType && (dChildrenList = ((ContainerType)this.dComponentType).getContents().getWidgetOrContainer()) != null) {
            this.children = new ArrayList<ComponentTypeWrapper>();
            for (ComponentType dChild : dChildrenList) {
                ComponentTypeWrapper wChild = new ComponentTypeWrapper(dChild);
                wChild.setParent(this);
                wChild.setWindow(this.window);
                wChild.parseData();
                this.children.add(wChild);
            }
        }
    }

    public ComponentTypeWrapper getParent() {
        return this.parent;
    }

    public void setParent(ComponentTypeWrapper parent) {
        this.parent = parent;
    }

    public List<GUITypeWrapper> getInvokedWindowList() {
        return this.invokedWindows;
    }

    public List<ComponentTypeWrapper> getChildren() {
        return this.children;
    }

    public void setWindow(GUITypeWrapper window) {
        this.window = window;
    }

    public GUITypeWrapper getWindow() {
        return this.window;
    }

    public ComponentType getDComponentType() {
        return this.dComponentType;
    }

    public ComponentTypeWrapper(ComponentType componentType) {
        this.dComponentType = componentType;
    }

    public PropertyType getFirstPropertyByName(String sName) {
        AttributesType attributes = this.dComponentType.getAttributes();
        if (attributes == null) {
            return null;
        }
        List<PropertyType> lProperty = attributes.getProperty();
        for (PropertyType p : lProperty) {
            if (!p.getName().equals(sName)) continue;
            return p;
        }
        return null;
    }

    public String getFirstValueByName(String sName) {
        PropertyType property = this.getFirstPropertyByName(sName);
        if (property != null && property.getValue().size() > 0) {
            return property.getValue().get(0);
        }
        return null;
    }

    public List<String> getValueListByName(String sName) {
        AttributesType attributes = this.dComponentType.getAttributes();
        if (attributes == null) {
            return null;
        }
        List<PropertyType> lProperty = attributes.getProperty();
        for (PropertyType p : lProperty) {
            if (!p.getName().equals(sName)) continue;
            return p.getValue();
        }
        return new ArrayList<String>();
    }

    public void setID(String ID) {
        AttributesType attributes = this.dComponentType.getAttributes();
        if (attributes == null) {
            return;
        }
        List<PropertyType> lProperty = attributes.getProperty();
        if (lProperty == null) {
            lProperty = new ArrayList<PropertyType>();
        }
        for (PropertyType p : lProperty) {
            if (!"ID".equals(p.getName())) continue;
            lProperty.remove(p);
            break;
        }
        PropertyType pID = factory.createPropertyType();
        pID.setName("ID");
        pID.getValue().add(ID);
        lProperty.add(0, pID);
    }

    public void setValueByName(String sTitle, String sName, String sValue) {
        String sMyTitle = this.getFirstValueByName("ID");
        if (sTitle.equals(sMyTitle)) {
            AttributesType attributes = this.dComponentType.getAttributes();
            List<PropertyType> lProperty = attributes.getProperty();
            for (PropertyType p : lProperty) {
                if (!p.getName().equals(sName)) continue;
                lProperty.remove(p);
                ArrayList<String> lValue = new ArrayList<String>();
                lValue.add(sValue);
                p.setValue(lValue);
                lProperty.add(p);
            }
            attributes.setProperty(lProperty);
            this.dComponentType.setAttributes(attributes);
        } else if (this.dComponentType instanceof ContainerType) {
            ContainerType container = (ContainerType)this.dComponentType;
            ContentsType contents = container.getContents();
            List<ComponentType> lChildren = container.getContents().getWidgetOrContainer();
            ArrayList<ComponentType> lNewChildren = new ArrayList<ComponentType>();
            for (ComponentType child : lChildren) {
                ComponentTypeWrapper childA = new ComponentTypeWrapper(child);
                childA.setValueByName(sTitle, sName, sValue);
                lNewChildren.add(childA.getDComponentType());
            }
            contents.setWidgetOrContainer(lNewChildren);
            ((ContainerType)this.dComponentType).setContents(contents);
        }
    }

    public void addValueByName(String sName, String sValue) {
        List<String> lValue;
        AttributesType attributes = this.dComponentType.getAttributes();
        if (attributes == null) {
            attributes = factory.createAttributesType();
        }
        List<PropertyType> lProperty = attributes.getProperty();
        PropertyType property = null;
        for (PropertyType aProperty : lProperty) {
            if (!sName.equals(aProperty.getName())) continue;
            lProperty.remove(aProperty);
            property = aProperty;
            break;
        }
        if (property == null) {
            property = new PropertyType();
            property.setName(sName);
        }
        if (!(lValue = property.getValue()).contains(sValue)) {
            lValue.add(sValue);
        }
        property.setValue(lValue);
        lProperty.add(property);
        attributes.setProperty(lProperty);
        this.dComponentType.setAttributes(attributes);
    }

    public void addValueByName(String sTitle, String sName, String sValue) {
        String sMyTitle = this.getFirstValueByName("ID");
        if (sTitle.equals(sMyTitle)) {
            AttributesType attributes = this.dComponentType.getAttributes();
            List<PropertyType> lProperty = attributes.getProperty();
            PropertyType p = new PropertyType();
            p.setName(sName);
            ArrayList<String> lValue = new ArrayList<String>();
            lValue.add(sValue);
            p.setValue(lValue);
            lProperty.add(p);
            attributes.setProperty(lProperty);
            this.dComponentType.setAttributes(attributes);
        } else if (this.dComponentType instanceof ContainerType) {
            ContainerType container = (ContainerType)this.dComponentType;
            ContentsType contents = container.getContents();
            List<ComponentType> lChildren = container.getContents().getWidgetOrContainer();
            ArrayList<ComponentType> lNewChildren = new ArrayList<ComponentType>();
            for (ComponentType child : lChildren) {
                ComponentTypeWrapper childA = new ComponentTypeWrapper(child);
                childA.addValueByName(sTitle, sName, sValue);
                lNewChildren.add(childA.getDComponentType());
            }
            contents.setWidgetOrContainer(lNewChildren);
            ((ContainerType)this.dComponentType).setContents(contents);
        }
    }

    public void removeProperty(String sName) {
        AttributesType attributes = this.dComponentType.getAttributes();
        if (attributes == null) {
            return;
        }
        List<PropertyType> lProperties = attributes.getProperty();
        if (lProperties == null) {
            return;
        }
        for (PropertyType property : lProperties) {
            if (!sName.equals(property.getName())) continue;
            lProperties.remove(property);
            break;
        }
    }

    public ComponentTypeWrapper getChildByID(String ID) {
        String sID = this.getFirstValueByName("ID");
        if (ID.equals(sID)) {
            return this;
        }
        if (this.dComponentType instanceof ContainerType) {
            List<ComponentTypeWrapper> lChildrenWrapper = this.children;
            if (lChildrenWrapper == null) {
                lChildrenWrapper = new ArrayList<ComponentTypeWrapper>();
                ContainerType container = (ContainerType)this.dComponentType;
                List<ComponentType> lChildren = container.getContents().getWidgetOrContainer();
                for (ComponentType child : lChildren) {
                    ComponentTypeWrapper childAdapter = new ComponentTypeWrapper(child);
                    lChildrenWrapper.add(childAdapter);
                }
            }
            for (ComponentTypeWrapper childAdapter : lChildrenWrapper) {
                ComponentTypeWrapper retComp = childAdapter.getChildByID(ID);
                if (retComp == null) continue;
                return retComp;
            }
        }
        return null;
    }

    public void printInfo() {
        List<PropertyType> properties = this.getDComponentType().getAttributes().getProperty();
        for (PropertyType p : properties) {
            String out = p.getName();
            for (String value : p.getValue()) {
                out = out + "\t" + value;
            }
            System.out.println(out);
        }
    }

    public boolean hasChild() {
        if (this.children == null) {
            return false;
        }
        return this.children.size() != 0;
    }

    public void addValueBySignature(AttributesType signature, String name, Set<String> values) {
        block4: {
            block3: {
                if (!this.isMatchSignature(signature)) break block3;
                for (String value : values) {
                    this.addValueByName(name, value);
                }
                break block4;
            }
            if (!(this.dComponentType instanceof ContainerType)) break block4;
            ContainerType container = (ContainerType)this.dComponentType;
            ContentsType contents = container.getContents();
            if (contents == null) {
                return;
            }
            List<ComponentType> lChildren = contents.getWidgetOrContainer();
            ArrayList<ComponentType> lNewChildren = new ArrayList<ComponentType>();
            for (ComponentType child : lChildren) {
                ComponentTypeWrapper childA = new ComponentTypeWrapper(child);
                childA.addValueBySignature(signature, name, values);
                lNewChildren.add(childA.getDComponentType());
            }
        }
    }

    public boolean isMatchSignature(AttributesType signature) {
        if (signature == null) {
            return false;
        }
        AttributesType attributes = this.dComponentType.getAttributes();
        if (attributes == null) {
            return false;
        }
        AttributesTypeWrapper wSignature = new AttributesTypeWrapper(signature);
        AttributesTypeWrapper wAttributes = new AttributesTypeWrapper(attributes);
        return wAttributes.containsAll(wSignature);
    }

    public ComponentTypeWrapper getComponentBySignature(AttributesType signature) {
        if (this.isMatchSignature(signature)) {
            return this;
        }
        if (this.dComponentType instanceof ContainerType) {
            ContainerType container = (ContainerType)this.dComponentType;
            ContentsType contents = container.getContents();
            if (contents == null) {
                return null;
            }
            List<ComponentType> lChildren = contents.getWidgetOrContainer();
            ComponentTypeWrapper result = null;
            for (ComponentType child : lChildren) {
                ComponentTypeWrapper childA = new ComponentTypeWrapper(child);
                result = childA.getComponentBySignature(signature);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public AttributesType getSubAttributes(List<String> lPropertyName) {
        AttributesType signature = factory.createAttributesType();
        AttributesType attributes = this.dComponentType.getAttributes();
        if (attributes == null) {
            return signature;
        }
        for (PropertyType property : attributes.getProperty()) {
            if (!lPropertyName.contains(property.getName())) continue;
            signature.getProperty().add(property);
        }
        return signature;
    }

    public void updateValueBySignature(AttributesType signature, String name, Set<String> values) {
        block4: {
            block3: {
                if (!this.isMatchSignature(signature)) break block3;
                for (String value : values) {
                    this.updateValueByName(name, value);
                }
                break block4;
            }
            if (!(this.dComponentType instanceof ContainerType)) break block4;
            ContainerType container = (ContainerType)this.dComponentType;
            ContentsType contents = container.getContents();
            if (contents == null) {
                return;
            }
            List<ComponentType> lChildren = contents.getWidgetOrContainer();
            ArrayList<ComponentType> lNewChildren = new ArrayList<ComponentType>();
            for (ComponentType child : lChildren) {
                ComponentTypeWrapper childA = new ComponentTypeWrapper(child);
                childA.updateValueBySignature(signature, name, values);
                lNewChildren.add(childA.getDComponentType());
            }
        }
    }

    private void updateValueByName(String name, String value) {
        List<PropertyType> lProperty;
        AttributesType attributes = this.dComponentType.getAttributes();
        if (attributes == null) {
            attributes = factory.createAttributesType();
        }
        if ((lProperty = attributes.getProperty()) == null) {
            lProperty = new ArrayList<PropertyType>();
        }
        int index = 0;
        for (PropertyType aProperty : lProperty) {
            if (!name.equals(aProperty.getName())) continue;
            index = lProperty.indexOf(aProperty);
            lProperty.remove(index);
            break;
        }
        PropertyType property = null;
        property = new PropertyType();
        property.setName(name);
        ArrayList<String> lValue = new ArrayList<String>();
        lValue.add(value);
        property.setValue(lValue);
        attributes.getProperty().add(index, property);
        this.dComponentType.setAttributes(attributes);
    }

    public int getMaxID() {
        String ID = this.getFirstValueByName("ID");
        int nMaxID = 0;
        if (ID == null) {
            nMaxID = 0;
        } else if (ID.length() < 1) {
            nMaxID = 0;
        } else {
            ID = ID.substring(1);
            try {
                nMaxID = Integer.parseInt(ID);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.dComponentType instanceof ContainerType) {
            ContainerType container = (ContainerType)this.dComponentType;
            ContentsType contents = container.getContents();
            if (contents == null) {
                return 0;
            }
            List<ComponentType> lChildren = contents.getWidgetOrContainer();
            for (ComponentType child : lChildren) {
                ComponentTypeWrapper childA = new ComponentTypeWrapper(child);
                int localMax = childA.getMaxID();
                if (nMaxID >= localMax) continue;
                nMaxID = localMax;
            }
        }
        return nMaxID;
    }

    public void updateID() {
        this.updateValueByName("ID", "w" + Integer.toString(ID_COUNTER++));
        if (this.dComponentType instanceof ContainerType) {
            ContainerType container = (ContainerType)this.dComponentType;
            ContentsType contents = container.getContents();
            if (contents == null) {
                return;
            }
            List<ComponentType> lChildren = contents.getWidgetOrContainer();
            ArrayList<ComponentType> lNewChildren = new ArrayList<ComponentType>();
            for (ComponentType child : lChildren) {
                ComponentTypeWrapper childA = new ComponentTypeWrapper(child);
                childA.updateID();
                lNewChildren.add(childA.getDComponentType());
            }
        }
    }

    public static void setID_COUNTER(int nID_COUNTER) {
        ID_COUNTER = nID_COUNTER;
    }

    public void generateID(GHashcodeGenerator hashcodeGenerator, GUITypeWrapper guiTypeWrapper) {
        long hashcode = hashcodeGenerator.getHashcodeFromData(this.dComponentType, guiTypeWrapper.getData());
        this.setID("w" + hashcode);
        if (this.dComponentType instanceof ContainerType) {
            ContainerType container = (ContainerType)this.dComponentType;
            ContentsType contents = container.getContents();
            if (contents == null) {
                return;
            }
            List<ComponentType> lChildren = contents.getWidgetOrContainer();
            ArrayList<ComponentType> lNewChildren = new ArrayList<ComponentType>();
            for (ComponentType child : lChildren) {
                ComponentTypeWrapper childA = new ComponentTypeWrapper(child);
                childA.generateID(hashcodeGenerator, guiTypeWrapper);
                lNewChildren.add(childA.getDComponentType());
            }
        }
    }

    public List<EventType> getEventList() {
        List<String> sActionList = this.getValueListByName("ReplayableAction");
        ArrayList<EventType> eventList = null;
        if (sActionList != null) {
            eventList = new ArrayList<EventType>();
        }
        for (String action : sActionList) {
            EventType event = new EventType();
            String wigetID = this.getFirstValueByName("ID");
            String eventID = wigetID.replace("w", "e");
            String type = this.getFirstValueByName("Type");
            String posFix = sActionList.size() <= 1 ? "" : EVENT_ID_SPLITTER + Integer.toString(sActionList.indexOf(action));
            eventID = eventID + posFix;
            event.setEventId(eventID);
            event.setWidgetId(wigetID);
            event.setAction(action);
            event.setType(type);
            eventList.add(event);
        }
        return eventList;
    }
}

