/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.util.Util;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.annotation.CheckForNull;

public class Version {
    public static final int MAJOR = 2;
    public static final int MINOR = 0;
    public static final int PATCHLEVEL = 0;
    public static final boolean IS_DEVELOPMENT = true;
    public static final int RELEASE_CANDIDATE = 1;
    public static final String SVN_REVISION;
    private static final String COMPUTED_DATE;
    public static final String DATE;
    private static final String COMPUTED_ECLIPSE_DATE;
    private static String applicationName;
    private static String applicationVersion;
    public static final int PREVIEW = 0;
    private static final String RELEASE_SUFFIX_WORD;
    public static final String RELEASE_BASE = "2.0.0";
    public static final String COMPUTED_RELEASE;
    public static final String RELEASE;
    private static final String COMPUTED_ECLIPSE_UI_VERSION;
    public static final String WEBSITE = "http://findbugs.sourceforge.net";
    public static final String DOWNLOADS_WEBSITE = "http://prdownloads.sourceforge.net/findbugs";
    public static final String SUPPORT_EMAIL = "http://findbugs.sourceforge.net/reportingBugs.html";
    private static Date releaseDate;

    public static void registerApplication(String name, String version) {
        applicationName = name;
        applicationVersion = version;
    }

    @CheckForNull
    public static String getApplicationName() {
        return applicationName;
    }

    @CheckForNull
    public static String getApplicationVersion() {
        return applicationVersion;
    }

    public static void main(String[] argv) {
        String arg;
        if (argv.length != 1) {
            Version.usage();
        }
        if ((arg = argv[0]).equals("-release")) {
            System.out.println(RELEASE);
        } else if (arg.equals("-date")) {
            System.out.println(DATE);
        } else if (arg.equals("-props")) {
            System.out.println("release.base=2.0.0");
            System.out.println("release.number=" + COMPUTED_RELEASE);
            System.out.println("release.date=" + COMPUTED_DATE);
            System.out.println("eclipse.ui.version=" + COMPUTED_ECLIPSE_UI_VERSION);
            System.out.println("findbugs.website=http://findbugs.sourceforge.net");
            System.out.println("findbugs.downloads.website=http://prdownloads.sourceforge.net/findbugs");
            System.out.println("findbugs.svn.revision=" + SVN_REVISION);
        } else if (arg.equals("-plugins")) {
            DetectorFactoryCollection.instance();
            for (Plugin p : Plugin.getAllPlugins()) {
                String website;
                System.out.println("Plugin: " + p.getPluginId());
                System.out.println("  description: " + p.getShortDescription());
                System.out.println("     provider: " + p.getProvider());
                String version = p.getVersion();
                if (version != null && version.length() > 0) {
                    System.out.println("      version: " + version);
                }
                if ((website = p.getWebsite()) != null && website.length() > 0) {
                    System.out.println("      website: " + website);
                }
                System.out.println();
            }
        } else {
            Version.usage();
            System.exit(1);
        }
    }

    private static void usage() {
        System.err.println("Usage: " + Version.class.getName() + "  (-release|-date|-props)");
    }

    public static String getReleaseWithDateIfDev() {
        return RELEASE + " (" + DATE + ")";
    }

    @CheckForNull
    public static Date getReleaseDate() {
        return releaseDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static {
        Date parsedDate;
        String suffix;
        SVN_REVISION = System.getProperty("svn.revision", "Unknown");
        applicationName = "";
        applicationVersion = "";
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss z, dd MMMM, yyyy");
        SimpleDateFormat eclipseDateFormat = new SimpleDateFormat("yyyyMMdd");
        COMPUTED_DATE = dateFormat.format(new Date());
        COMPUTED_ECLIPSE_DATE = eclipseDateFormat.format(new Date());
        RELEASE_SUFFIX_WORD = suffix = "rc1";
        COMPUTED_RELEASE = RELEASE_BASE + ("-" + RELEASE_SUFFIX_WORD);
        COMPUTED_ECLIPSE_UI_VERSION = "2.0.0." + COMPUTED_ECLIPSE_DATE;
        Class<Version> c = Version.class;
        URL u = c.getResource(c.getSimpleName() + ".class");
        boolean fromFile = u.getProtocol().equals("file");
        InputStream in = null;
        String release = null;
        String date = null;
        if (!fromFile) {
            block9: {
                try {
                    Properties versionProperties = new Properties();
                    in = Version.class.getResourceAsStream("version.properties");
                    if (in == null) break block9;
                    versionProperties.load(in);
                    release = (String)versionProperties.get("release.number");
                    date = (String)versionProperties.get("release.date");
                }
                catch (Exception e) {
                    Util.closeSilently(in);
                    catch (Throwable throwable) {
                        Util.closeSilently(in);
                        throw throwable;
                    }
                }
            }
            Util.closeSilently(in);
        }
        if (release == null) {
            release = COMPUTED_RELEASE;
        }
        if (date == null) {
            date = COMPUTED_DATE;
        }
        RELEASE = release;
        DATE = date;
        try {
            parsedDate = DateFormat.getDateTimeInstance().parse(DATE);
        }
        catch (ParseException e) {
            parsedDate = null;
        }
        releaseDate = parsedDate;
    }
}

