/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.BlockOrder;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Location;
import org.apache.bcel.generic.InstructionHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface DataflowAnalysis<Fact> {
    public Fact createFact();

    public Fact getStartFact(BasicBlock var1);

    public Fact getResultFact(BasicBlock var1);

    public Fact getFactAtLocation(Location var1) throws DataflowAnalysisException;

    public Fact getFactAfterLocation(Location var1) throws DataflowAnalysisException;

    public Fact getFactOnEdge(Edge var1) throws DataflowAnalysisException;

    public void copy(Fact var1, Fact var2);

    public void initEntryFact(Fact var1) throws DataflowAnalysisException;

    public void makeFactTop(Fact var1);

    public boolean isTop(Fact var1);

    public boolean isForwards();

    public BlockOrder getBlockOrder(CFG var1);

    public boolean same(Fact var1, Fact var2);

    public void transfer(BasicBlock var1, @CheckForNull InstructionHandle var2, Fact var3, Fact var4) throws DataflowAnalysisException;

    public void edgeTransfer(Edge var1, Fact var2) throws DataflowAnalysisException;

    public void meetInto(Fact var1, Edge var2, Fact var3) throws DataflowAnalysisException;

    public void startIteration();

    public void finishIteration();

    public int getLastUpdateTimestamp(Fact var1);

    public void setLastUpdateTimestamp(Fact var1, int var2);

    public String factToString(Fact var1);
}

