/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy2;
import edu.umd.cs.findbugs.ba.InnerClassAccess;
import edu.umd.cs.findbugs.ba.JavaClassAndMethod;
import edu.umd.cs.findbugs.ba.JavaClassAndMethodChooser;
import edu.umd.cs.findbugs.ba.ObjectTypeFactory;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.ba.type.NullType;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hierarchy {
    protected static final boolean DEBUG_METHOD_LOOKUP = SystemProperties.getBoolean("hier.lookup.debug");
    public static ClassDescriptor RUNTIME_EXCEPTION = DescriptorFactory.createClassDescriptor(RuntimeException.class);
    public static ClassDescriptor EXCEPTION = DescriptorFactory.createClassDescriptor(Exception.class);
    public static ClassDescriptor ERROR = DescriptorFactory.createClassDescriptor(Error.class);
    public static final ObjectType EXCEPTION_TYPE = ObjectTypeFactory.getInstance("java.lang.Exception");
    public static final ObjectType ERROR_TYPE = ObjectTypeFactory.getInstance("java.lang.Error");
    public static final ObjectType RUNTIME_EXCEPTION_TYPE = ObjectTypeFactory.getInstance("java.lang.RuntimeException");
    static Map<ReferenceType, Map<ReferenceType, Boolean>> subtypeCache = new HashMap<ReferenceType, Map<ReferenceType, Boolean>>();
    public static final JavaClassAndMethodChooser ANY_METHOD = new JavaClassAndMethodChooser(){

        public boolean choose(JavaClassAndMethod javaClassAndMethod) {
            return true;
        }

        public boolean choose(XMethod method) {
            return true;
        }
    };
    public static final JavaClassAndMethodChooser CONCRETE_METHOD = new JavaClassAndMethodChooser(){

        public boolean choose(JavaClassAndMethod javaClassAndMethod) {
            Method method = javaClassAndMethod.getMethod();
            int accessFlags = method.getAccessFlags();
            return Hierarchy.accessFlagsAreConcrete(accessFlags);
        }

        public boolean choose(XMethod method) {
            return Hierarchy.accessFlagsAreConcrete(method.getAccessFlags());
        }
    };
    public static final JavaClassAndMethodChooser STATIC_METHOD = new JavaClassAndMethodChooser(){

        public boolean choose(JavaClassAndMethod javaClassAndMethod) {
            return javaClassAndMethod.getMethod().isStatic();
        }

        public boolean choose(XMethod method) {
            return method.isStatic();
        }
    };
    public static final JavaClassAndMethodChooser INSTANCE_METHOD = new JavaClassAndMethodChooser(){

        public boolean choose(JavaClassAndMethod javaClassAndMethod) {
            return !javaClassAndMethod.getMethod().isStatic();
        }

        public boolean choose(XMethod method) {
            return !method.isStatic();
        }
    };

    public static boolean isSubtype(@DottedClassName String clsName, @DottedClassName String possibleSupertypeClassName) throws ClassNotFoundException {
        Subtypes2 subtypes2 = Global.getAnalysisCache().getDatabase(Subtypes2.class);
        return subtypes2.isSubtype(DescriptorFactory.createClassDescriptorFromDottedClassName(clsName), DescriptorFactory.createClassDescriptorFromDottedClassName(possibleSupertypeClassName));
    }

    public static boolean isSubtype(ReferenceType t, ReferenceType possibleSupertype) throws ClassNotFoundException {
        return Global.getAnalysisCache().getDatabase(Subtypes2.class).isSubtype(t, possibleSupertype);
    }

    public static boolean isUniversalExceptionHandler(ObjectType catchType) {
        return catchType == null || catchType.equals(Type.THROWABLE);
    }

    public static boolean isUncheckedException(ObjectType type) throws ClassNotFoundException {
        if (type.equals(Type.THROWABLE) || type.equals(RUNTIME_EXCEPTION_TYPE) || type.equals(ERROR_TYPE)) {
            return true;
        }
        ClassDescriptor c = DescriptorFactory.getClassDescriptor(type);
        Subtypes2 subtypes2 = Global.getAnalysisCache().getDatabase(Subtypes2.class);
        return subtypes2.isSubtype(c, RUNTIME_EXCEPTION, ERROR);
    }

    public static boolean isMonitorWait(String methodName, String methodSig) {
        return methodName.equals("wait") && (methodSig.equals("()V") || methodSig.equals("(J)V") || methodSig.equals("(JI)V"));
    }

    public static boolean isMonitorWait(Instruction ins, ConstantPoolGen cpg) {
        if (!(ins instanceof InvokeInstruction)) {
            return false;
        }
        if (ins.getOpcode() == 184) {
            return false;
        }
        InvokeInstruction inv = (InvokeInstruction)ins;
        String methodName = inv.getMethodName(cpg);
        String methodSig = inv.getSignature(cpg);
        return Hierarchy.isMonitorWait(methodName, methodSig);
    }

    public static boolean isMonitorNotify(String methodName, String methodSig) {
        return (methodName.equals("notify") || methodName.equals("notifyAll")) && methodSig.equals("()V");
    }

    public static boolean isMonitorNotify(Instruction ins, ConstantPoolGen cpg) {
        if (!(ins instanceof InvokeInstruction)) {
            return false;
        }
        if (ins.getOpcode() == 184) {
            return false;
        }
        InvokeInstruction inv = (InvokeInstruction)ins;
        String methodName = inv.getMethodName(cpg);
        String methodSig = inv.getSignature(cpg);
        return Hierarchy.isMonitorNotify(methodName, methodSig);
    }

    public static JavaClassAndMethod findExactMethod(InvokeInstruction inv, ConstantPoolGen cpg) throws ClassNotFoundException {
        return Hierarchy.findExactMethod(inv, cpg, ANY_METHOD);
    }

    public static JavaClassAndMethod findExactMethod(InvokeInstruction inv, ConstantPoolGen cpg, JavaClassAndMethodChooser chooser) throws ClassNotFoundException {
        String className = inv.getClassName(cpg);
        String methodName = inv.getName(cpg);
        String methodSig = inv.getSignature(cpg);
        JavaClass jclass = Repository.lookupClass(className);
        return Hierarchy.findMethod(jclass, methodName, methodSig, chooser);
    }

    public static JavaClassAndMethod visitSuperClassMethods(JavaClassAndMethod method, JavaClassAndMethodChooser chooser) throws ClassNotFoundException {
        return Hierarchy.findMethod(method.getJavaClass().getSuperClasses(), method.getMethod().getName(), method.getMethod().getSignature(), chooser);
    }

    public static JavaClassAndMethod visitSuperInterfaceMethods(JavaClassAndMethod method, JavaClassAndMethodChooser chooser) throws ClassNotFoundException {
        return Hierarchy.findMethod(method.getJavaClass().getAllInterfaces(), method.getMethod().getName(), method.getMethod().getSignature(), chooser);
    }

    @CheckForNull
    public static JavaClassAndMethod findInvocationLeastUpperBound(InvokeInstruction inv, ConstantPoolGen cpg) throws ClassNotFoundException {
        return Hierarchy.findInvocationLeastUpperBound(inv, cpg, ANY_METHOD);
    }

    @CheckForNull
    public static JavaClassAndMethod findInvocationLeastUpperBound(InvokeInstruction inv, ConstantPoolGen cpg, JavaClassAndMethodChooser methodChooser) throws ClassNotFoundException {
        short opcode;
        if (DEBUG_METHOD_LOOKUP) {
            System.out.println("Find prototype method for " + SignatureConverter.convertMethodSignature(inv, cpg));
        }
        if ((opcode = inv.getOpcode()) == 184 ? methodChooser == INSTANCE_METHOD : methodChooser == STATIC_METHOD) {
            return null;
        }
        if (opcode == 183) {
            return Hierarchy.findExactMethod(inv, cpg, methodChooser);
        }
        String className = inv.getClassName(cpg);
        String methodName = inv.getName(cpg);
        String methodSig = inv.getSignature(cpg);
        if (DEBUG_METHOD_LOOKUP) {
            System.out.println("[Class name is " + className + "]");
            System.out.println("[Method name is " + methodName + "]");
            System.out.println("[Method signature is " + methodSig + "]");
        }
        if (className.startsWith("[")) {
            className = "java.lang.Object";
        }
        JavaClass jClass = Repository.lookupClass(className);
        return Hierarchy.findInvocationLeastUpperBound(jClass, methodName, methodSig, methodChooser, opcode == 185);
    }

    @CheckForNull
    public static JavaClassAndMethod findInvocationLeastUpperBound(JavaClass jClass, String methodName, String methodSig, JavaClassAndMethodChooser methodChooser, boolean invokeInterface) throws ClassNotFoundException {
        JavaClassAndMethod result = Hierarchy.findMethod(jClass, methodName, methodSig, methodChooser);
        if (result != null) {
            return result;
        }
        if (invokeInterface) {
            for (JavaClass i : jClass.getInterfaces()) {
                result = Hierarchy.findInvocationLeastUpperBound(i, methodName, methodSig, methodChooser, invokeInterface);
                if (result == null) continue;
                return null;
            }
        } else {
            JavaClass sClass = jClass.getSuperClass();
            if (sClass != null) {
                return Hierarchy.findInvocationLeastUpperBound(sClass, methodName, methodSig, methodChooser, invokeInterface);
            }
        }
        return null;
    }

    @Deprecated
    public static ObjectType[] findDeclaredExceptions(InvokeInstruction inv, ConstantPoolGen cpg) {
        return Hierarchy2.findDeclaredExceptions(inv, cpg);
    }

    @CheckForNull
    public static JavaClassAndMethod findMethod(JavaClass javaClass, String methodName, String methodSig) {
        return Hierarchy.findMethod(javaClass, methodName, methodSig, ANY_METHOD);
    }

    @CheckForNull
    public static JavaClassAndMethod findMethod(JavaClass javaClass, String methodName, String methodSig, JavaClassAndMethodChooser chooser) {
        Method[] methodList;
        if (DEBUG_METHOD_LOOKUP) {
            System.out.println("Check " + javaClass.getClassName());
        }
        for (Method method : methodList = javaClass.getMethods()) {
            JavaClassAndMethod m;
            if (!method.getName().equals(methodName) || !method.getSignature().equals(methodSig) || !chooser.choose(m = new JavaClassAndMethod(javaClass, method))) continue;
            if (DEBUG_METHOD_LOOKUP) {
                System.out.println("\t==> FOUND: " + method);
            }
            return m;
        }
        if (DEBUG_METHOD_LOOKUP) {
            System.out.println("\t==> NOT FOUND");
        }
        return null;
    }

    @CheckForNull
    public static XMethod findMethod(ClassDescriptor classDesc, String methodName, String methodSig, boolean isStatic) {
        if (DEBUG_METHOD_LOOKUP) {
            System.out.println("Check " + classDesc.getClassName());
        }
        try {
            XClass xClass = Global.getAnalysisCache().getClassAnalysis(XClass.class, classDesc);
            return xClass.findMethod(methodName, methodSig, isStatic);
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Error looking for " + classDesc + "." + methodName + methodSig, e);
            return null;
        }
    }

    @Deprecated
    @CheckForNull
    public static JavaClassAndMethod findConcreteMethod(JavaClass javaClass, String methodName, String methodSig) {
        Method[] methodList;
        if (DEBUG_METHOD_LOOKUP) {
            System.out.println("Check " + javaClass.getClassName());
        }
        for (Method method : methodList = javaClass.getMethods()) {
            if (!method.getName().equals(methodName) || !method.getSignature().equals(methodSig) || !Hierarchy.accessFlagsAreConcrete(method.getAccessFlags())) continue;
            JavaClassAndMethod m = new JavaClassAndMethod(javaClass, method);
            return m;
        }
        if (DEBUG_METHOD_LOOKUP) {
            System.out.println("\t==> NOT FOUND");
        }
        return null;
    }

    @Deprecated
    @CheckForNull
    public static XMethod findXMethod(JavaClass javaClass, String methodName, String methodSig, JavaClassAndMethodChooser chooser) {
        JavaClassAndMethod result = Hierarchy.findMethod(javaClass, methodName, methodSig, chooser);
        return result == null ? null : XFactory.createXMethod(result.getJavaClass(), result.getMethod());
    }

    public static boolean accessFlagsAreConcrete(int accessFlags) {
        return (accessFlags & 0x400) == 0 && (accessFlags & 0x100) == 0;
    }

    @Deprecated
    public static JavaClassAndMethod findMethod(JavaClass[] classList, String methodName, String methodSig) {
        return Hierarchy.findMethod(classList, methodName, methodSig, ANY_METHOD);
    }

    public static JavaClassAndMethod findMethod(JavaClass[] classList, String methodName, String methodSig, JavaClassAndMethodChooser chooser) {
        JavaClass cls;
        JavaClassAndMethod m = null;
        JavaClass[] arr$ = classList;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (m = Hierarchy.findMethod(cls = arr$[i$], methodName, methodSig, chooser)) == null; ++i$) {
        }
        return m;
    }

    @Deprecated
    public static XMethod findXMethod(JavaClass[] classList, String methodName, String methodSig) {
        return Hierarchy.findXMethod(classList, methodName, methodSig, ANY_METHOD);
    }

    @Deprecated
    public static XMethod findXMethod(JavaClass[] classList, String methodName, String methodSig, JavaClassAndMethodChooser chooser) {
        for (JavaClass cls : classList) {
            JavaClassAndMethod m = Hierarchy.findMethod(cls, methodName, methodSig);
            if (m == null || !chooser.choose(m)) continue;
            return XFactory.createXMethod(cls, m.getMethod());
        }
        return null;
    }

    public static Set<JavaClassAndMethod> resolveMethodCallTargets(InvokeInstruction invokeInstruction, TypeFrame typeFrame, ConstantPoolGen cpg) throws DataflowAnalysisException, ClassNotFoundException {
        boolean receiverTypeIsExact;
        Type receiverType;
        short opcode = invokeInstruction.getOpcode();
        if (opcode == 184) {
            HashSet<JavaClassAndMethod> result = new HashSet<JavaClassAndMethod>();
            JavaClassAndMethod targetMethod = Hierarchy.findInvocationLeastUpperBound(invokeInstruction, cpg, CONCRETE_METHOD);
            if (targetMethod != null) {
                result.add(targetMethod);
            }
            return result;
        }
        if (!typeFrame.isValid()) {
            return new HashSet<JavaClassAndMethod>();
        }
        if (opcode == 183) {
            receiverType = ObjectTypeFactory.getInstance(invokeInstruction.getClassName(cpg));
            receiverTypeIsExact = false;
        } else {
            int instanceStackLocation = typeFrame.getInstanceStackLocation(invokeInstruction, cpg);
            receiverType = (Type)typeFrame.getStackValue(instanceStackLocation);
            if (!(receiverType instanceof ReferenceType)) {
                return new HashSet<JavaClassAndMethod>();
            }
            receiverTypeIsExact = typeFrame.isExact(instanceStackLocation);
        }
        if (DEBUG_METHOD_LOOKUP) {
            System.out.println("[receiver type is " + receiverType + ", " + (receiverTypeIsExact ? "exact]" : " not exact]"));
        }
        return Hierarchy.resolveMethodCallTargets(receiverType, invokeInstruction, cpg, receiverTypeIsExact);
    }

    public static Set<JavaClassAndMethod> resolveMethodCallTargets(ReferenceType receiverType, InvokeInstruction invokeInstruction, ConstantPoolGen cpg) throws ClassNotFoundException {
        return Hierarchy.resolveMethodCallTargets(receiverType, invokeInstruction, cpg, false);
    }

    public static Set<JavaClassAndMethod> resolveMethodCallTargets(ReferenceType receiverType, InvokeInstruction invokeInstruction, ConstantPoolGen cpg, boolean receiverTypeIsExact) throws ClassNotFoundException {
        boolean virtualCall;
        HashSet<JavaClassAndMethod> result = new HashSet<JavaClassAndMethod>();
        if (invokeInstruction.getOpcode() == 184) {
            throw new IllegalArgumentException();
        }
        String methodName = invokeInstruction.getName(cpg);
        String methodSig = invokeInstruction.getSignature(cpg);
        if (receiverType instanceof ArrayType) {
            JavaClass javaLangObject = AnalysisContext.currentAnalysisContext().lookupClass("java.lang.Object");
            JavaClassAndMethod classAndMethod = Hierarchy.findMethod(javaLangObject, methodName, methodSig, INSTANCE_METHOD);
            if (classAndMethod != null) {
                result.add(classAndMethod);
            }
            return result;
        }
        if (receiverType instanceof NullType) {
            return Collections.emptySet();
        }
        AnalysisContext analysisContext = AnalysisContext.currentAnalysisContext();
        String receiverClassName = ((ObjectType)receiverType).getClassName();
        JavaClass receiverClass = analysisContext.lookupClass(receiverClassName);
        ClassDescriptor receiverDesc = DescriptorFactory.createClassDescriptorFromDottedClassName(receiverClassName);
        JavaClassAndMethod upperBound = Hierarchy.findMethod(receiverClass, methodName, methodSig, CONCRETE_METHOD);
        if (upperBound == null) {
            upperBound = Hierarchy.findInvocationLeastUpperBound(receiverClass, methodName, methodSig, CONCRETE_METHOD, false);
        }
        if (upperBound != null) {
            if (DEBUG_METHOD_LOOKUP) {
                System.out.println("Adding upper bound: " + SignatureConverter.convertMethodSignature(upperBound.getJavaClass(), upperBound.getMethod()));
            }
            result.add(upperBound);
        }
        boolean bl = virtualCall = (invokeInstruction.getOpcode() == 182 || invokeInstruction.getOpcode() == 185) && (upperBound == null || !upperBound.getJavaClass().isFinal() && !upperBound.getMethod().isFinal()) && !receiverTypeIsExact;
        if (virtualCall && !receiverClassName.equals("java.lang.Object")) {
            Set<ClassDescriptor> subTypeSet = analysisContext.getSubtypes2().getSubtypes(receiverDesc);
            for (ClassDescriptor subtype : subTypeSet) {
                XMethod concreteSubtypeMethod = Hierarchy.findMethod(subtype, methodName, methodSig, false);
                if (concreteSubtypeMethod == null || (concreteSubtypeMethod.getAccessFlags() & 0x400) != 0) continue;
                result.add(new JavaClassAndMethod(concreteSubtypeMethod));
            }
        }
        return result;
    }

    @Deprecated
    public static boolean isConcrete(XMethod xmethod) {
        int accessFlags = xmethod.getAccessFlags();
        return (accessFlags & 0x400) == 0 && (accessFlags & 0x100) == 0;
    }

    public static Field findField(String className, String fieldName) throws ClassNotFoundException {
        for (JavaClass jclass = Repository.lookupClass(className); jclass != null; jclass = jclass.getSuperClass()) {
            Field[] fieldList;
            for (Field field : fieldList = jclass.getFields()) {
                if (!field.getName().equals(fieldName)) continue;
                return field;
            }
        }
        return null;
    }

    public static XField findXField(String className, String fieldName, String fieldSig, boolean isStatic) {
        return XFactory.createXField(className, fieldName, fieldSig, isStatic);
    }

    @CheckForNull
    public static XField findXField(FieldInstruction fins, @Nonnull ConstantPoolGen cpg) {
        String className = fins.getClassName(cpg);
        String fieldName = fins.getFieldName(cpg);
        String fieldSig = fins.getSignature(cpg);
        boolean isStatic = fins.getOpcode() == 178 || fins.getOpcode() == 179;
        XField xfield = Hierarchy.findXField(className, fieldName, fieldSig, isStatic);
        short opcode = fins.getOpcode();
        if (xfield != null && xfield.isResolved() && xfield.isStatic() == (opcode == 178 || opcode == 179)) {
            return xfield;
        }
        return null;
    }

    public static boolean isInnerClassAccess(INVOKESTATIC inv, ConstantPoolGen cpg) {
        String methodName = inv.getName(cpg);
        return methodName.startsWith("access$");
    }

    public static InnerClassAccess getInnerClassAccess(INVOKESTATIC inv, ConstantPoolGen cpg) throws ClassNotFoundException {
        String className = inv.getClassName(cpg);
        String methodName = inv.getName(cpg);
        String methodSig = inv.getSignature(cpg);
        InnerClassAccess access = AnalysisContext.currentAnalysisContext().getInnerClassAccessMap().getInnerClassAccess(className, methodName);
        return access != null && access.getMethodSignature().equals(methodSig) ? access : null;
    }
}

