/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.type;

import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Frame;
import edu.umd.cs.findbugs.ba.type.BottomType;
import edu.umd.cs.findbugs.ba.type.DoubleExtraType;
import edu.umd.cs.findbugs.ba.type.LongExtraType;
import edu.umd.cs.findbugs.ba.type.NullType;
import edu.umd.cs.findbugs.ba.type.TopType;
import java.util.BitSet;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeFrame
extends Frame<Type> {
    private BitSet exactTypeSet = new BitSet();

    public TypeFrame(int numLocals) {
        super(numLocals);
    }

    public void setExact(int slot, boolean isExact) {
        this.exactTypeSet.set(slot, isExact);
    }

    public boolean isExact(int slot) {
        return this.exactTypeSet.get(slot);
    }

    public void clearExactSet() {
        this.exactTypeSet.clear();
    }

    @Override
    public void setTop() {
        super.setTop();
        this.clearExactSet();
    }

    @Override
    public void copyFrom(Frame<Type> other_) {
        this.clearExactSet();
        TypeFrame other = (TypeFrame)other_;
        this.exactTypeSet.or(other.exactTypeSet);
        super.copyFrom(other_);
    }

    @Override
    protected String valueToString(Type value) {
        return String.valueOf(value) + ",";
    }

    public static Type getTopType() {
        return TopType.instance();
    }

    public static Type getBottomType() {
        return BottomType.instance();
    }

    public static Type getLongExtraType() {
        return LongExtraType.instance();
    }

    public static Type getDoubleExtraType() {
        return DoubleExtraType.instance();
    }

    public static Type getNullType() {
        return NullType.instance();
    }

    @Override
    public void pushValue(Type value) {
        block2: {
            super.pushValue(value);
            try {
                this.exactTypeSet.clear(this.getStackLocation(0));
            }
            catch (DataflowAnalysisException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    @Override
    public Type popValue() throws DataflowAnalysisException {
        this.exactTypeSet.clear(this.getStackLocation(0));
        return (Type)super.popValue();
    }

    @Override
    public String toString() {
        int start;
        if (this.isTop()) {
            return "[TOP]";
        }
        if (this.isBottom()) {
            return "[BOTTOM]";
        }
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int numSlots = this.getNumSlots();
        for (int i = start = 0; i < numSlots; ++i) {
            if (i == this.getNumLocals()) {
                int last = buf.length() - 1;
                if (last >= 0 && buf.charAt(last) == ',') {
                    buf.deleteCharAt(last);
                }
                buf.append(" | ");
            }
            if (this.isExact(i)) {
                buf.append("!");
            }
            String value = this.valueToString((Type)this.getValue(i));
            if (i == numSlots - 1 && value.endsWith(",")) {
                value = value.substring(0, value.length() - 1);
            }
            buf.append(value);
        }
        buf.append(']');
        return buf.toString();
    }
}

