/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.cloud.username;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.PropertyBundle;
import edu.umd.cs.findbugs.charsets.UTF8;
import edu.umd.cs.findbugs.cloud.CloudPlugin;
import edu.umd.cs.findbugs.cloud.username.NameLookup;
import edu.umd.cs.findbugs.util.LaunchBrowser;
import edu.umd.cs.findbugs.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public class WebCloudNameLookup
implements NameLookup {
    private static final String APPENGINE_HOST_PROPERTY_NAME = "webcloud.host";
    private static final String KEY_SAVE_SESSION_INFO = "save_session_info";
    static final String KEY_APPENGINECLOUD_SESSION_ID = "webcloud_session_id";
    private static final String SYSPROP_NEVER_SAVE_SESSION = "webcloud.never_save_session";
    private static final Logger LOGGER = Logger.getLogger(WebCloudNameLookup.class.getName());
    private static final int USER_SIGNIN_TIMEOUT_SECS = 60;
    private Long sessionId;
    private String username;
    private String url;

    public boolean signIn(CloudPlugin plugin, BugCollection bugCollection) throws IOException {
        this.loadProperties(plugin);
        if (this.softSignin()) {
            return true;
        }
        if (this.sessionId == null) {
            this.sessionId = this.loadOrCreateSessionId();
        }
        LOGGER.info("Opening browser for session " + this.sessionId);
        URL u = new URL(this.url + "/browser-auth/" + this.sessionId);
        LaunchBrowser.showDocument(u);
        for (int i = 0; i < 60; ++i) {
            if (this.checkAuthorized(this.getAuthCheckUrl(this.sessionId))) {
                return true;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        LOGGER.info("Sign-in timed out for " + this.sessionId);
        throw new IOException("Sign-in timed out");
    }

    public void loadProperties(CloudPlugin plugin) {
        PropertyBundle pluginProps = plugin.getProperties();
        this.url = pluginProps.getProperty(APPENGINE_HOST_PROPERTY_NAME);
        if (this.url == null) {
            throw new IllegalStateException("Host not specified for " + plugin.getId());
        }
    }

    public boolean softSignin() throws IOException {
        long id;
        if (this.url == null) {
            throw new IllegalStateException("Null host");
        }
        this.checkResolveHost();
        if (this.sessionId != null) {
            if (this.checkAuthorized(this.getAuthCheckUrl(this.sessionId))) {
                LOGGER.fine("Skipping soft init; session ID already exists - " + this.sessionId);
                return true;
            }
            this.sessionId = null;
        }
        if ((id = this.loadSessionId()) == 0L) {
            return false;
        }
        boolean authorized = this.checkAuthorized(this.getAuthCheckUrl(id));
        if (authorized) {
            LOGGER.info("Authorized with session ID: " + id);
            this.sessionId = id;
        }
        return authorized;
    }

    public void checkResolveHost() throws UnknownHostException {
        try {
            String host = new URL(this.url).getHost();
            InetAddress.getByName(host);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private URL getAuthCheckUrl(long sessionId) throws MalformedURLException {
        return new URL(this.url + "/check-auth/" + sessionId);
    }

    public static void setSaveSessionInformation(boolean save) {
        Preferences prefs = Preferences.userNodeForPackage(WebCloudNameLookup.class);
        prefs.putBoolean(KEY_SAVE_SESSION_INFO, save);
        if (!save) {
            WebCloudNameLookup.clearSavedSessionInformation();
        }
    }

    public static boolean isSavingSessionInfoEnabled() {
        return !Boolean.getBoolean(SYSPROP_NEVER_SAVE_SESSION) && Preferences.userNodeForPackage(WebCloudNameLookup.class).getBoolean(KEY_SAVE_SESSION_INFO, true);
    }

    public static void clearSavedSessionInformation() {
        Preferences prefs = Preferences.userNodeForPackage(WebCloudNameLookup.class);
        prefs.remove(KEY_APPENGINECLOUD_SESSION_ID);
    }

    public static void saveSessionInformation(long sessionId) {
        assert (sessionId != 0L);
        Preferences.userNodeForPackage(WebCloudNameLookup.class).putLong(KEY_APPENGINECLOUD_SESSION_ID, sessionId);
    }

    public Long getSessionId() {
        return this.sessionId;
    }

    public String getUsername() {
        return this.username;
    }

    public String getHost() {
        return this.url;
    }

    private long loadOrCreateSessionId() {
        long id = this.loadSessionId();
        if (id != 0L) {
            LOGGER.info("Using saved session ID: " + id);
            return id;
        }
        SecureRandom r = new SecureRandom();
        while (id == 0L) {
            id = r.nextLong();
        }
        if (WebCloudNameLookup.isSavingSessionInfoEnabled()) {
            WebCloudNameLookup.saveSessionInformation(id);
        }
        return id;
    }

    private long loadSessionId() {
        Preferences prefs = Preferences.userNodeForPackage(WebCloudNameLookup.class);
        return prefs.getLong(KEY_APPENGINECLOUD_SESSION_ID, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAuthorized(URL response) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)response.openConnection();
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            InputStream in = connection.getInputStream();
            BufferedReader reader = UTF8.bufferedReader(in);
            try {
                String status = reader.readLine();
                this.sessionId = Long.parseLong(reader.readLine());
                this.username = reader.readLine();
                Util.closeSilently(reader);
                if ("OK".equals(status)) {
                    LOGGER.info("Authorized session " + this.sessionId);
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                reader.close();
            }
        }
        connection.disconnect();
        return false;
    }
}

