/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;

public class ConfusedInheritance
extends PreorderVisitor
implements Detector {
    private BugReporter bugReporter;
    private JavaClass cls;

    public ConfusedInheritance(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        this.cls = classContext.getJavaClass();
        if (this.cls.isFinal()) {
            this.cls.accept(this);
        }
    }

    public void visitField(Field obj) {
        if (obj.isProtected()) {
            this.bugReporter.reportBug(new BugInstance(this, "CI_CONFUSED_INHERITANCE", 3).addClass(this.cls).addField(new FieldAnnotation(this.cls.getClassName(), obj.getName(), obj.getSignature(), obj.isStatic())));
        }
    }

    public void report() {
    }
}

