/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.sourceViewer;

import java.text.CharacterIterator;
import java.util.HashSet;

public class JavaScanner {
    public static final int NORMAL_TEXT = 0;
    public static final int COMMENT = 1;
    public static final int JAVADOC = 2;
    public static final int KEYWORD = 3;
    public static final int QUOTE = 4;
    public static final int EOF = -1;
    private static final HashSet<String> KEYWORDS = new HashSet();
    private static final int MAX_KEYWORD_LENGTH;
    private final StringBuilder buf = new StringBuilder();
    private final CharacterIterator iterator;
    private int kind;
    private int startPosition;

    public JavaScanner(CharacterIterator iterator) {
        this.iterator = iterator;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public int getEndPosition() {
        return this.iterator.getIndex();
    }

    public int getLength() {
        return this.iterator.getIndex() - this.startPosition;
    }

    public int getKind() {
        return this.kind;
    }

    public int next() {
        this.startPosition = this.iterator.getIndex();
        char c = this.iterator.current();
        this.iterator.next();
        if (c == '\uffff') {
            this.kind = -1;
        } else if (Character.isJavaIdentifierStart(c)) {
            this.buf.append(c);
            boolean couldBeKeyword = Character.isLowerCase(c);
            while (Character.isJavaIdentifierPart(c = this.iterator.current())) {
                this.buf.append(c);
                if (couldBeKeyword && (!Character.isLowerCase(c) || this.buf.length() > MAX_KEYWORD_LENGTH)) {
                    couldBeKeyword = false;
                }
                c = this.iterator.next();
            }
            this.kind = 0;
            if (couldBeKeyword && KEYWORDS.contains(this.buf.toString())) {
                this.kind = 3;
            }
            this.buf.setLength(0);
        } else if (c == '/') {
            char c2 = this.iterator.current();
            if (c2 == '/') {
                while ((c2 = this.iterator.next()) != '\n' && c2 != '\r' && c2 != '\uffff') {
                }
                this.kind = 1;
                return this.kind;
            }
            if (c2 == '*') {
                block2: while (c2 != '\uffff') {
                    c2 = this.iterator.next();
                    if (c2 != '*') continue;
                    while ((c2 = this.iterator.next()) != '/') {
                        if (c2 == '*') continue;
                        continue block2;
                    }
                    break block2;
                }
                this.kind = 2;
                return this.kind;
            }
        } else if (c == '\"') {
            this.kind = 4;
            char c2 = this.iterator.current();
            while (c2 != '\"' && c2 != '\n' && c2 != '\r' && c2 != '\uffff' && (c2 != '\\' || (c2 = this.iterator.next()) != '\n' && c2 != '\r')) {
                c2 = this.iterator.next();
            }
            this.iterator.next();
        } else if (c == '\'') {
            this.kind = 4;
            char c2 = this.iterator.current();
            if (c2 == '\\') {
                c2 = this.iterator.next();
            }
            if (c2 != '\n' && c2 != '\r' && c2 != '\uffff') {
                c2 = this.iterator.next();
            }
            if (c2 != '\n' && c2 != '\r' && c2 != '\uffff') {
                this.iterator.next();
            }
        } else {
            this.kind = 0;
        }
        return this.kind;
    }

    static {
        String[] keywordList = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
        int max = 0;
        for (String s : keywordList) {
            if (max < s.length()) {
                max = s.length();
            }
            KEYWORDS.add(s);
        }
        MAX_KEYWORD_LENGTH = max;
    }
}

