/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.sourceViewer;

import edu.umd.cs.findbugs.gui2.Driver;
import edu.umd.cs.findbugs.sourceViewer.HighlightInformation;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.WeakHashMap;
import javax.swing.text.Element;
import javax.swing.text.ParagraphView;
import javax.swing.text.View;

class NumberedParagraphView
extends ParagraphView {
    public static final int NUMBERS_WIDTH = (int)Driver.getFontSize() * 3 + 9;
    HighlightInformation highlight;
    static WeakHashMap<Element, Integer> elementLineNumberCache = new WeakHashMap();

    public NumberedParagraphView(Element e, HighlightInformation highlight) {
        super(e);
        this.highlight = highlight;
    }

    public void paint(Graphics g, Shape allocation) {
        Rectangle r = allocation instanceof Rectangle ? (Rectangle)allocation : allocation.getBounds();
        Color oldColor = g.getColor();
        Integer lineNumber = this.getLineNumber();
        Color highlightColor = this.highlight.getHighlight(lineNumber);
        if (highlightColor != null) {
            g.setColor(highlightColor);
            g.fillRect(r.x, r.y, r.width, r.height);
            g.setColor(oldColor);
        }
        super.paint(g, r);
        FontMetrics metrics = g.getFontMetrics();
        g.setColor(Color.GRAY);
        String lineNumberString = lineNumber.toString();
        int width = metrics.stringWidth(lineNumberString);
        int numberX = r.x - width - 9 + NUMBERS_WIDTH;
        int numberY = r.y + metrics.getAscent();
        g.drawString(lineNumberString, numberX, numberY);
        g.setColor(oldColor);
    }

    public int getPreviousLineCount0() {
        int lineCount = 0;
        View parent = this.getParent();
        int count = parent.getViewCount();
        for (int i = 0; i < count && parent.getView(i) != this; ++i) {
            lineCount += parent.getView(i).getViewCount();
        }
        return lineCount;
    }

    public Integer getLineNumber() {
        Element element = this.getElement();
        Integer result = elementLineNumberCache.get(element);
        if (result != null) {
            return result;
        }
        Element parent = element.getParentElement();
        int count = parent.getElementCount();
        for (int i = 0; i < count; ++i) {
            elementLineNumberCache.put(parent.getElement(i), i + 1);
        }
        result = elementLineNumberCache.get(element);
        if (result != null) {
            return result;
        }
        return -1;
    }
}

