package de.ugoe.cs.util.console;

import java.io.File;

import junitx.framework.FileAssert;

import org.junit.*;
import static org.junit.Assert.*;

/**
 * The class <code>FileOutputListenerTest</code> contains tests for the class <code>{@link FileOutputListener}</code>.
 *
 * @author Steffen Herbold
 * @version 1.0
 */
public class FileOutputListenerTest {
	
	String expectedOutputFilename = "testdata/de.ugoe.cs.util.FileOutputListenerTest/expected.log";
	String testOutputPath = "testoutput/";
	String testFilename = testOutputPath + "listener.log";
	
	FileOutputListener listener;
	
	@Test
	public void testFileOutputListener_1()
		throws Exception {
		String filename = "filename";

		FileOutputListener result = new FileOutputListener(filename);
		
		assertNotNull(result);
		assertEquals(filename, result.getFilename());
	}

	@Test
	public void testOutputMsg_1()
		throws Exception {
		String message = "test";
		
		listener.start();
		listener.outputMsg(message);
		listener.stop();

		FileAssert.assertEquals(new File(expectedOutputFilename), new File(testFilename));
	}

	@Test
	public void testStart_1()
		throws Exception {
		FileOutputListener fixture = new FileOutputListener(testFilename);

		fixture.start();
		
		File file = new File(testFilename);
		assertTrue(file.exists());
	}
	
	@Test
	public void testStart_2()
		throws Exception {
		FileOutputListener fixture = new FileOutputListener("");

		fixture.start();
		
		assertNull(fixture.writer);
	}

	@Test
	public void testStop_1()
		throws Exception {
		listener.stop();
		assertNull(listener.writer);
	}

	@Before
	public void setUp()
		throws Exception {
		// add additional set up code here
		Console.reset();
		listener = new FileOutputListener(testFilename);
		File file = new File(testFilename);
		if( file.exists() ) {
			file.delete();
		}
	}

	@After
	public void tearDown()
		throws Exception {
		if( listener.writer!=null ) {
			listener.writer.close();
		}
	}

	public static void main(String[] args) {
		new org.junit.runner.JUnitCore().run(FileOutputListenerTest.class);
	}
}