//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.httpmonitor;

/**
 * <p>
 * This is a simple id generator that uses the timestamps as id. If {@link #getNextId()} is called
 * twice in the same millisecond, than just the next millisecond is used.
 * </p>
 * 
 * @author Patrick Harms
 */
public class SimpleIdGenerator implements IdGenerator {
    
    /** */
    private long lastId;

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.httpmonitor.HttpMonitorComponent#init()
     */
    @Override
    public void init() throws IllegalStateException, HttpMonitorException {
        lastId = System.currentTimeMillis();
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.httpmonitor.HttpMonitorComponent#start()
     */
    @Override
    public void start() throws IllegalStateException, HttpMonitorException {
        // nothing to do
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.httpmonitor.HttpMonitorComponent#stop()
     */
    @Override
    public void stop() {
        // nothing to do
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.httpmonitor.IdGenerator#getNextId()
     */
    @Override
    public synchronized long getNextId() {
        long newId = System.currentTimeMillis();
        
        if (newId <= lastId) {
            newId = lastId + 1;
        }
        
        lastId = newId;
        
        return newId;
    }

}
