//   Copyright 2015 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.genericevents.eventCore;

import de.ugoe.cs.autoquest.eventcore.EventTargetModelConfigurationException;
import de.ugoe.cs.autoquest.eventcore.HierarchicalEventTargetModel;
import de.ugoe.cs.autoquest.eventcore.IEventTargetFactory;
import de.ugoe.cs.autoquest.eventcore.IEventTargetSpec;
import de.ugoe.cs.autoquest.eventcore.IHierarchicalEventTarget;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Patrick Harms
 */
public class GenericEventTargetFactory implements IEventTargetFactory {

    /* (non-Javadoc)
     * @see IEventTargetFactory#instantiateEventTarget(IEventTargetSpec, IHierarchicalEventTarget)
     */
    @SuppressWarnings("unchecked")
    @Override
    public <T extends IHierarchicalEventTarget> T instantiateEventTarget(IEventTargetSpec specification,
                                                                         T                parent)
        throws EventTargetModelConfigurationException
    {
        if ((specification instanceof GenericEventTargetSpec) &&
            ((parent == null) || (parent instanceof GenericEventTarget)))
        {
            return (T) instantiateEventTarget((GenericEventTargetSpec) specification,
                                              (GenericEventTarget) parent);
        }
        else {
            throw new IllegalArgumentException
                ("can only handle parameters of type GenericEventTargetSpec and GenericEventTarget");
        }
    }

    /* (non-Javadoc)
     * @see IEventTargetFactory#instantiateEventTarget(IEventTargetSpec, IHierarchicalEventTarget)
     */
    public GenericEventTarget instantiateEventTarget(GenericEventTargetSpec specification,
                                                     GenericEventTarget     parent)
        throws EventTargetModelConfigurationException
    {
        return new GenericEventTarget(specification, parent);
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.eventcore.IEventTargetFactory#instantiateGroup(java.lang.String, de.ugoe.cs.autoquest.eventcore.IHierarchicalEventTarget, de.ugoe.cs.autoquest.eventcore.HierarchicalEventTargetModel)
     */
    @Override
    public <T extends IHierarchicalEventTarget> T instantiateGroup(String                          groupName,
                                                                   T                               parent,
                                                                   HierarchicalEventTargetModel<T> hierarchicalEventTargetModel)
    {
        throw new UnsupportedOperationException();
    }

}
