//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.ui.swt;

import java.util.Collections;
import java.util.LinkedList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;

import de.ugoe.cs.autoquest.usability.UsabilityEvaluationResult;
import de.ugoe.cs.util.console.GlobalDataContainer;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

public class UsabilityTabComposite extends Composite {

    /** */
    private List evaluationResultsList;

    /** */
    private Button btnShow;

    /** */
    private Button btnDelete_1;

    /**
     * Create the composite.
     * 
     * @param parent
     * @param style
     */
    public UsabilityTabComposite(Composite parent, int style) {
        super(parent, style);
        createContents();
    }

    /**
     * 
     */
    private void createContents() {
        setLayout(new GridLayout(5, false));

        evaluationResultsList = new List(this, SWT.BORDER | SWT.V_SCROLL);
        evaluationResultsList.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 5, 1));
        evaluationResultsList.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                String[] selectedStrings = evaluationResultsList.getSelection();
                if (selectedStrings.length == 1) {
                    btnShow.setEnabled(true);
                    btnDelete_1.setEnabled(true);
                }
                else if (selectedStrings.length > 1) {
                    btnShow.setEnabled(false);
                    btnDelete_1.setEnabled(true);
                }
                else {
                    btnShow.setEnabled(false);
                    btnDelete_1.setEnabled(false);
                }
            }
        });

        btnShow = new Button(this, SWT.NONE);
        btnShow.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                String[] selectedStrings = evaluationResultsList.getSelection();
                if (selectedStrings.length == 0) {
                    SWTHelpers.noSelectionError(getShell());
                    return;
                }
                else if (selectedStrings.length > 1) {
                    SWTHelpers.moreThanOneSelectedError(getShell());
                    return;
                }

                Object obj = GlobalDataContainer.getInstance().getData(selectedStrings[0]);

                if (obj instanceof UsabilityEvaluationResult) {
                    ShowUsabilityEvaluationResultDialog showUsabilityEvaluationResultDialog =
                        new ShowUsabilityEvaluationResultDialog
                            (getShell(), SWT.NONE, (UsabilityEvaluationResult) obj,
                             selectedStrings[0]);
                    showUsabilityEvaluationResultDialog.open();
                }
                else {
                    MessageBox messageBox = new MessageBox(getShell(), SWT.NONE);
                    messageBox.setText("Feature Not Available");
                    messageBox.setMessage("This feature is currently only available for " +
                                          "usability evaluation results.");
                    messageBox.open();
                }
            }
        });
        btnShow.setText("Show");
        btnShow.setEnabled(false);

        btnDelete_1 = new Button(this, SWT.NONE);
        btnDelete_1.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                if (SWTHelpers.deleteSelectedFromStorage(evaluationResultsList)) {
                    updateResultList();
                }
                else {
                    SWTHelpers.noSelectionError(getShell());
                }
            }
        });
        btnDelete_1.setText("Delete");
        btnDelete_1.setEnabled(false);
    }

    /**
     * 
     */
    @Override
    protected void checkSubclass() {
        // Disable the check that prevents subclassing of SWT components
    }

    /**
     * 
     */
    public void updateResultList() {
        evaluationResultsList.removeAll();
        
        java.util.List<String> results = new LinkedList<>();
        
        for (String key : GlobalDataContainer.getInstance().getAllKeys()) {
            Object data = GlobalDataContainer.getInstance().getData(key);
            if (data instanceof UsabilityEvaluationResult) {
                results.add(key);
            }
        }
        
        Collections.sort(results);
        
        for (String entry : results) {
            evaluationResultsList.add(entry);
        }
    }

}
