//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.nodeequality;

import static org.junit.Assert.*;

import org.junit.Test;

import de.ugoe.cs.autoquest.tasktrees.nodeequality.IterationComparisonRule;
import de.ugoe.cs.autoquest.tasktrees.nodeequality.NodeEquality;
import de.ugoe.cs.autoquest.tasktrees.nodeequality.NodeEqualityRuleManager;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IIteration;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISelection;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeBuilder;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNodeFactory;
import de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskTreeBuilder;
import de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskTreeNode;
import de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskTreeNodeFactory;

/**
 * @author Patrick Harms
 */
public class IterationComparisonRuleTest {

    /**
     *
     */
    @Test
    public void test() {
        NodeEqualityRuleManager manager = new NodeEqualityRuleManager();
        manager.init();
        
        ITaskTreeNodeFactory treeNodeFactory = new TaskTreeNodeFactory();
        ITaskTreeBuilder treeBuilder = new TaskTreeBuilder();
        
        IterationComparisonRule rule = new IterationComparisonRule(manager);
        
        ITaskTreeNode task1 = new TaskTreeNode("task1");
        ITaskTreeNode task2 = new TaskTreeNode("task2");
        
        assertFalse(rule.isApplicable(task1, task2));
        
        IIteration iteration1 = treeNodeFactory.createNewIteration();
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(iteration1, iteration1));

        IIteration iteration2 = treeNodeFactory.createNewIteration();
        
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(iteration1, iteration2));
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(iteration2, iteration1));
        
        treeBuilder.setChild(iteration1, task1);
        
        assertEquals(NodeEquality.UNEQUAL, rule.compare(iteration1, iteration2));
        assertEquals(NodeEquality.UNEQUAL, rule.compare(iteration2, iteration1));
        
        treeBuilder.setChild(iteration2, task1);
        
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(iteration1, iteration2));
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(iteration2, iteration1));
        
        treeBuilder.setChild(iteration1, task2);
        
        assertEquals(NodeEquality.UNEQUAL, rule.compare(iteration1, iteration2));
        assertEquals(NodeEquality.UNEQUAL, rule.compare(iteration2, iteration1));
        
        treeBuilder.setChild(iteration2, task2);
        
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(iteration1, iteration2));
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(iteration2, iteration1));
        
        ISelection selection1 = treeNodeFactory.createNewSelection();
        treeBuilder.addChild(selection1, task2);
        treeBuilder.setChild(iteration1, selection1);
        
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(iteration1, iteration2));
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(iteration2, iteration1));
        
        ISelection selection2 = treeNodeFactory.createNewSelection();
        treeBuilder.addChild(selection2, task2);
        treeBuilder.setChild(iteration2, selection2);
        
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(iteration1, iteration2));
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(iteration2, iteration1));
        
        assertFalse(rule.isApplicable(iteration1, selection1));
        assertFalse(rule.isApplicable(selection1, iteration1));
        assertFalse(rule.isApplicable(iteration2, selection1));
        assertFalse(rule.isApplicable(selection1, iteration2));

        assertFalse(rule.isApplicable(iteration1, selection2));
        assertFalse(rule.isApplicable(selection2, iteration1));
        assertFalse(rule.isApplicable(iteration2, selection2));
        assertFalse(rule.isApplicable(selection2, iteration2));
    }

}
