//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.nodeequality;

import static org.junit.Assert.*;

import org.junit.Test;

import de.ugoe.cs.autoquest.tasktrees.nodeequality.NodeEquality;
import de.ugoe.cs.autoquest.tasktrees.nodeequality.NodeEqualityRuleManager;
import de.ugoe.cs.autoquest.tasktrees.nodeequality.SequenceComparisonRule;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISelection;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISequence;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeBuilder;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNodeFactory;
import de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskTreeBuilder;
import de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskTreeNode;
import de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskTreeNodeFactory;

/**
 * @author Patrick Harms
 */
public class SequenceComparisonRuleTest {

    /**
     * 
     */
    @Test
    public void test() {
        NodeEqualityRuleManager manager = new NodeEqualityRuleManager();
        manager.init();
        
        ITaskTreeNodeFactory treeNodeFactory = new TaskTreeNodeFactory();
        ITaskTreeBuilder treeBuilder = new TaskTreeBuilder();
        
        SequenceComparisonRule rule = new SequenceComparisonRule(manager);
        
        ITaskTreeNode task1 = new TaskTreeNode("task1");
        ITaskTreeNode task2 = new TaskTreeNode("task2");
        
        assertFalse(rule.isApplicable(task1, task2));
        
        ISequence sequence1 = treeNodeFactory.createNewSequence();
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(sequence1, sequence1));

        ISequence sequence2 = treeNodeFactory.createNewSequence();
        
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(sequence1, sequence2));
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(sequence2, sequence1));
        
        treeBuilder.addChild(sequence1, task1);
        
        assertEquals(NodeEquality.UNEQUAL, rule.compare(sequence1, sequence2));
        assertEquals(NodeEquality.UNEQUAL, rule.compare(sequence2, sequence1));
        
        treeBuilder.addChild(sequence2, task1);
        
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(sequence1, sequence2));
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(sequence2, sequence1));
        
        treeBuilder.addChild(sequence1, task2);
        
        assertEquals(NodeEquality.UNEQUAL, rule.compare(sequence1, sequence2));
        assertEquals(NodeEquality.UNEQUAL, rule.compare(sequence2, sequence1));
        
        treeBuilder.addChild(sequence2, task2);
        
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(sequence1, sequence2));
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(sequence2, sequence1));
        
        ISequence sequence3 = treeNodeFactory.createNewSequence();
        treeBuilder.addChild(sequence3, task2);
        treeBuilder.addChild(sequence3, task1);
        
        assertEquals(NodeEquality.UNEQUAL, rule.compare(sequence1, sequence3));
        assertEquals(NodeEquality.UNEQUAL, rule.compare(sequence3, sequence1));
        assertEquals(NodeEquality.UNEQUAL, rule.compare(sequence2, sequence3));
        assertEquals(NodeEquality.UNEQUAL, rule.compare(sequence3, sequence2));

        ISelection selection = treeNodeFactory.createNewSelection();
        assertFalse(rule.isApplicable(sequence1, selection));
        assertFalse(rule.isApplicable(selection, sequence1));
        assertFalse(rule.isApplicable(sequence2, selection));
        assertFalse(rule.isApplicable(selection, sequence2));
        assertFalse(rule.isApplicable(sequence3, selection));
        assertFalse(rule.isApplicable(selection, sequence3));
    }

}
