//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.temporalrelation;

import org.junit.Test;

import de.ugoe.cs.autoquest.eventcore.IEventTarget;
import de.ugoe.cs.autoquest.eventcore.IEventType;
import de.ugoe.cs.autoquest.tasktrees.TaskTreeChecker;
import de.ugoe.cs.autoquest.test.DummyGUIElement;
import de.ugoe.cs.autoquest.test.DummyInteraction;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 28.04.2012$
 * @author 2012, last modified by $Author: patrick$
 */
public class IterationOfSubtreesDetectionRuleTest extends AbstractTemporalRelationshipTC {

    /**
     *
     */
    @Test
    public void testInteractionIterationDetection() throws Exception {
        IEventTarget element1 = new DummyGUIElement("elem1");
        IEventType event1 = new DummyInteraction("bla", 1);
        simulateEvent(event1, element1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Event bla {}" +
             "}", getTaskTree(IterationOfSubtreesDetectionRule.class, null));

        simulateEvent(event1, element1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration iteration1 {" +
             "    Event bla {}" +
             "  }" +
             "}", getTaskTree(IterationOfSubtreesDetectionRule.class, null));

        simulateEvent(event1, element1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration iteration1 {" +
             "    Event bla {}" +
             "  }" +
             "}", getTaskTree(IterationOfSubtreesDetectionRule.class, null));

        for (int i = 0; i < 10; i++) {
            simulateEvent(event1, element1);
        }

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration iteration1 {" +
             "    Event bla {}" +
             "  }" +
             "}", getTaskTree(IterationOfSubtreesDetectionRule.class, null));

        // now test with preceding and trailing other events
        IEventType event2 = new DummyInteraction("bli", 1);
        IEventType event3 = new DummyInteraction("blup", 1);

        simulateEvent(event2, element1);
        simulateEvent(event3, element1);
        for (int i = 0; i < 10; i++) {
            simulateEvent(event1, element1);
        }
        simulateEvent(event3, element1);
        simulateEvent(event2, element1);

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration iteration1 {" +
             "    Event bla {}" +
             "  }" +
             "  Event bli {}" +
             "  Event blup {}" +
             "  Iteration iteration2 {" +
             "    Event bla {}" +
             "  }" +
             "  Event blup {}" +
             "  Event bli {}" +
             "}", getTaskTree(IterationOfSubtreesDetectionRule.class, null));

        // now test with iterations of iterations

        for (int i = 0; i < 10; i++) {
            for (int j = 0; j < 5; j++) {
                simulateEvent(event1, element1);
            }
            for (int j = 0; j < 5; j++) {
                simulateEvent(event2, element1);
            }
            for (int j = 0; j < 5; j++) {
                simulateEvent(event3, element1);
            }
        }

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration iteration1 {" +
             "    Event bla {}" +
             "  }" +
             "  Event bli {}" +
             "  Event blup {}" +
             "  Iteration iteration2 {" +
             "    Event bla {}" +
             "  }" +
             "  Event blup {}" +
             "  Event bli {}" +
             "  Iteration iteration3 {" +
             "    Sequence sequence2 {" +
             "      Iteration iteration4 {" +
             "        Event bla {}" +
             "      }" +
             "      Iteration iteration5 {" +
             "        Event bli {}" +
             "      }" +
             "      Iteration iteration6 {" +
             "        Event blup {}" +
             "      }" +
             "    }" +
             "  }" +
             "}", getTaskTree(IterationOfSubtreesDetectionRule.class, null));

    }

    /**
     *
     */
    @Test
    public void testSequenceIterationDetection() throws Exception {
        IEventTarget element1 = new DummyGUIElement("elem1");
        IEventType event1 = new DummyInteraction("bla", 1);
        IEventType event2 = new DummyInteraction("bli", 1);
        IEventType event3 = new DummyInteraction("blup", 1);
        simulateEvent(event1, element1);
        simulateEvent(event2, element1);
        simulateEvent(event3, element1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Event bla {}" +
             "  Event bli {}" +
             "  Event blup {}" +
             "}", getTaskTree(IterationOfSubtreesDetectionRule.class, null));

        simulateEvent(event1, element1);
        simulateEvent(event2, element1);
        simulateEvent(event3, element1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration iteration1 {" +
             "    Sequence sequence2 {" +
             "      Event bla {}" +
             "      Event bli {}" +
             "      Event blup {}" +
             "    }" +
             "  }" +
             "}", getTaskTree(IterationOfSubtreesDetectionRule.class, null));

        simulateEvent(event1, element1);
        simulateEvent(event2, element1);
        simulateEvent(event3, element1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration iteration1 {" +
             "    Sequence sequence2 {" +
             "      Event bla {}" +
             "      Event bli {}" +
             "      Event blup {}" +
             "    }" +
             "  }" +
             "}", getTaskTree(IterationOfSubtreesDetectionRule.class, null));

        for (int i = 0; i < 10; i++) {
            simulateEvent(event1, element1);
            simulateEvent(event2, element1);
            simulateEvent(event3, element1);
        }

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration iteration1 {" +
             "    Sequence sequence2 {" +
             "      Event bla {}" +
             "      Event bli {}" +
             "      Event blup {}" +
             "    }" +
             "  }" +
             "}", getTaskTree(IterationOfSubtreesDetectionRule.class, null));

        // now test with preceding and trailing other events
        IEventType event4 = new DummyInteraction("ble", 1);
        IEventType event5 = new DummyInteraction("blo", 1);
        IEventType event6 = new DummyInteraction("blu", 1);
        simulateEvent(event4, element1);
        simulateEvent(event5, element1);
        simulateEvent(event6, element1);
        for (int i = 0; i < 10; i++) {
            simulateEvent(event1, element1);
            simulateEvent(event2, element1);
            simulateEvent(event3, element1);
        }
        simulateEvent(event6, element1);
        simulateEvent(event5, element1);
        simulateEvent(event4, element1);

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration iteration1 {" +
             "    Sequence sequence2 {" +
             "      Event bla {}" +
             "      Event bli {}" +
             "      Event blup {}" +
             "    }" +
             "  }" +
             "  Event ble {}" +
             "  Event blo {}" +
             "  Event blu {}" +
             "  Iteration iteration2 {" +
             "    Sequence sequence3 {" +
             "      Event bla {}" +
             "      Event bli {}" +
             "      Event blup {}" +
             "    }" +
             "  }" +
             "  Event blu {}" +
             "  Event blo {}" +
             "  Event ble {}" +
             "}", getTaskTree(IterationOfSubtreesDetectionRule.class, null));

        // now test with iterations of iterations
        for (int i = 0; i < 10; i++) {
            for (int j = 0; j < 5; j++) {
                simulateEvent(event1, element1);
                simulateEvent(event2, element1);
                simulateEvent(event3, element1);
            }
            for (int j = 0; j < 5; j++) {
                simulateEvent(event2, element1);
                simulateEvent(event1, element1);
                simulateEvent(event3, element1);
            }
            for (int j = 0; j < 5; j++) {
                simulateEvent(event1, element1);
                simulateEvent(event2, element1);
                simulateEvent(event3, element1);
            }
        }

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration iteration1 {" +
             "    Sequence sequence2 {" +
             "      Event bla {}" +
             "      Event bli {}" +
             "      Event blup {}" +
             "    }" +
             "  }" +
             "  Event ble {}" +
             "  Event blo {}" +
             "  Event blu {}" +
             "  Iteration iteration2 {" +
             "    Sequence sequence3 {" +
             "      Event bla {}" +
             "      Event bli {}" +
             "      Event blup {}" +
             "    }" +
             "  }" +
             "  Event blu {}" +
             "  Event blo {}" +
             "  Event ble {}" +
             "  Iteration iteration3 {" +
             "    Sequence sequence4 {" +
             "      Iteration iteration4 {" +
             "        Sequence sequence4 {" +
             "          Event bla {}" +
             "          Event bli {}" +
             "          Event blup {}" +
             "        }" +
             "      }" +
             "      Iteration iteration5 {" +
             "        Sequence sequence5 {" +
             "          Event bli {}" +
             "          Event bla {}" +
             "          Event blup {}" +
             "        }" +
             "      }" +
             "      Iteration iteration6 {" +
             "        Sequence sequence6 {" +
             "          Event bla {}" +
             "          Event bli {}" +
             "          Event blup {}" +
             "        }" +
             "      }" +
             "    }" +
             "  }" +
             "}", getTaskTree(IterationOfSubtreesDetectionRule.class, null));
    }

}
