//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.taskequality;

import static org.junit.Assert.*;

import org.junit.Test;

import de.ugoe.cs.autoquest.eventcore.IEventTarget;
import de.ugoe.cs.autoquest.eventcore.IEventType;
import de.ugoe.cs.autoquest.eventcore.StringEventType;
import de.ugoe.cs.autoquest.tasktrees.taskequality.EventTaskComparisonRule;
import de.ugoe.cs.autoquest.tasktrees.taskequality.TaskEquality;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.test.DummyGUIElement;

/**
 * @author Patrick Harms
 */
public class EventTaskComparisonRuleTest extends AbstractComparisonRuleTest {

    /**
     *
     */
    @Test
    public void test_isApplicable_01() {
        EventTaskComparisonRule rule = new EventTaskComparisonRule();

        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        ITask task1 = createNewEventTask(eventType1, eventTarget1);

        assertTrue(rule.isApplicable(task1, task1));
    }
    
    /**
     *
     */
    @Test
    public void test_isApplicable_02() {
        EventTaskComparisonRule rule = new EventTaskComparisonRule();

        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        ITask task1 = createNewEventTask(eventType1, eventTarget1);

        IEventType eventType2 = new StringEventType("eventType2");
        IEventTarget eventTarget2 = new DummyGUIElement("elem2");
        ITask task2 = createNewEventTask(eventType2, eventTarget2);

        assertTrue(rule.isApplicable(task1, task2));
        assertTrue(rule.isApplicable(task2, task1));
    }
   
    /**
     *
     */
    @Test
    public void test_isApplicable_03() {
        EventTaskComparisonRule rule = new EventTaskComparisonRule();

        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        ITask task1 = createNewEventTask(eventType1, eventTarget1);
       
        ITask selection = createNewSelection();

        assertFalse(rule.isApplicable(task1, selection));
        assertFalse(rule.isApplicable(selection, task1));
    }
    
    /**
     *
     */
    @Test
    public void test_isApplicable_04() {
        EventTaskComparisonRule rule = new EventTaskComparisonRule();

        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        ITask task1 = createNewEventTask(eventType1, eventTarget1);

        ITask sequence = createNewSequence();

        assertFalse(rule.isApplicable(task1, sequence));
        assertFalse(rule.isApplicable(sequence, task1));
    }
    
    /**
     *
     */
    @Test
    public void test_isApplicable_05() {
        EventTaskComparisonRule rule = new EventTaskComparisonRule();

        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        ITask task1 = createNewEventTask(eventType1, eventTarget1);

        ITask iteration = createNewIteration();

        assertFalse(rule.isApplicable(task1, iteration));
        assertFalse(rule.isApplicable(iteration, task1));
    }
    
    /**
     *
     */
    @Test
    public void test_isApplicable_06() {
        EventTaskComparisonRule rule = new EventTaskComparisonRule();

        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        ITask task1 = createNewEventTask(eventType1, eventTarget1);

        ITask optional = createNewOptional();

        assertFalse(rule.isApplicable(task1, optional));
        assertFalse(rule.isApplicable(optional, task1));
    }
    
    /**
     *
     */
    @Test
    public void test_isApplicable_07() {
        EventTaskComparisonRule rule = new EventTaskComparisonRule();

        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        ITask task1 = createNewEventTask(eventType1, eventTarget1);

        assertTrue(rule.isApplicable(task1.getInstances().iterator().next(),
                                     task1.getInstances().iterator().next()));
    }
   
    /**
     *
     */
    @Test
    public void test_isApplicable_08() {
        EventTaskComparisonRule rule = new EventTaskComparisonRule();

        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        ITask task1 = createNewEventTask(eventType1, eventTarget1);

        IEventType eventType2 = new StringEventType("eventType2");
        IEventTarget eventTarget2 = new DummyGUIElement("elem2");
        ITask task2 = createNewEventTask(eventType2, eventTarget2);

        assertTrue(rule.isApplicable(task1.getInstances().iterator().next(),
                                     task2.getInstances().iterator().next()));
        assertTrue(rule.isApplicable(task2.getInstances().iterator().next(),
                                     task1.getInstances().iterator().next()));
    }

    /**
     *
     */
    @Test
    public void test_isApplicable_09() {
        EventTaskComparisonRule rule = new EventTaskComparisonRule();

        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        ITask task1 = createNewEventTask(eventType1, eventTarget1);

        ITask selection = createNewSelection();

        assertFalse(rule.isApplicable(task1.getInstances().iterator().next(),
                                      selection.getInstances().iterator().next()));
        assertFalse(rule.isApplicable(selection.getInstances().iterator().next(),
                                      task1.getInstances().iterator().next()));
    }

    /**
     *
     */
    @Test
    public void test_isApplicable_10() {
        EventTaskComparisonRule rule = new EventTaskComparisonRule();

        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        ITask task1 = createNewEventTask(eventType1, eventTarget1);

        ITask sequence = createNewSequence();

        assertFalse(rule.isApplicable(task1.getInstances().iterator().next(),
                                      sequence.getInstances().iterator().next()));
        assertFalse(rule.isApplicable(sequence.getInstances().iterator().next(),
                                      task1.getInstances().iterator().next()));
    }

    /**
     *
     */
    @Test
    public void test_isApplicable_11() {
        EventTaskComparisonRule rule = new EventTaskComparisonRule();

        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        ITask task1 = createNewEventTask(eventType1, eventTarget1);

        ITask iteration = createNewIteration();

        assertFalse(rule.isApplicable(task1.getInstances().iterator().next(),
                                      iteration.getInstances().iterator().next()));
        assertFalse(rule.isApplicable(iteration.getInstances().iterator().next(),
                                      task1.getInstances().iterator().next()));
    }

    /**
     *
     */
    @Test
    public void test_isApplicable_12() {
        EventTaskComparisonRule rule = new EventTaskComparisonRule();

        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        ITask task1 = createNewEventTask(eventType1, eventTarget1);

        ITask optional = createNewOptional();

        assertFalse(rule.isApplicable(task1.getInstances().iterator().next(),
                                      optional.getInstances().iterator().next()));
        assertFalse(rule.isApplicable(optional.getInstances().iterator().next(),
                                      task1.getInstances().iterator().next()));
    }

    /**
     *
     */
    @Test
    public void test_compare_01() {
        EventTaskComparisonRule rule = new EventTaskComparisonRule();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        ITask task1 = createNewEventTask(eventType1, eventTarget1);
        
        assertEquals(TaskEquality.LEXICALLY_EQUAL, rule.compare(task1, task1));
        assertTrue(rule.areLexicallyEqual(task1, task1));
        assertTrue(rule.areSyntacticallyEqual(task1, task1));
        assertTrue(rule.areSemanticallyEqual(task1, task1));
    }
    
    /**
     *
     */
    @Test
    public void test_compare_02() {
        EventTaskComparisonRule rule = new EventTaskComparisonRule();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        ITask task1 = createNewEventTask(eventType1, eventTarget1);
        
        ITask task2 = createNewEventTask(eventType1, eventTarget1);
        
        assertEquals(TaskEquality.LEXICALLY_EQUAL, rule.compare(task1, task2));
        assertTrue(rule.areLexicallyEqual(task1, task2));
        assertTrue(rule.areSyntacticallyEqual(task1, task2));
        assertTrue(rule.areSemanticallyEqual(task1, task2));

        assertEquals(TaskEquality.LEXICALLY_EQUAL, rule.compare(task2, task1));
        assertTrue(rule.areLexicallyEqual(task2, task1));
        assertTrue(rule.areSyntacticallyEqual(task2, task1));
        assertTrue(rule.areSemanticallyEqual(task2, task1));
    }

    /**
     *
     */
    @Test
    public void test_compare_03() {
        EventTaskComparisonRule rule = new EventTaskComparisonRule();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        ITask task1 = createNewEventTask(eventType1, eventTarget1);
        
        IEventType eventType2 = new StringEventType("eventType2");
        ITask task2 = createNewEventTask(eventType2, eventTarget1);

        assertEquals(TaskEquality.UNEQUAL, rule.compare(task1, task2));
        assertFalse(rule.areLexicallyEqual(task1, task2));
        assertFalse(rule.areSyntacticallyEqual(task1, task2));
        assertFalse(rule.areSemanticallyEqual(task1, task2));

        assertEquals(TaskEquality.UNEQUAL, rule.compare(task2, task1));
        assertFalse(rule.areLexicallyEqual(task2, task1));
        assertFalse(rule.areSyntacticallyEqual(task2, task1));
        assertFalse(rule.areSemanticallyEqual(task2, task1));
    }

    /**
     *
     */
    @Test
    public void test_compare_04() {
        EventTaskComparisonRule rule = new EventTaskComparisonRule();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        ITask task1 = createNewEventTask(eventType1, eventTarget1);
        
        IEventTarget eventTarget2 = new DummyGUIElement("elem2");
        ITask task2 = createNewEventTask(eventType1, eventTarget2);
        
        assertEquals(TaskEquality.UNEQUAL, rule.compare(task1, task2));
        assertFalse(rule.areLexicallyEqual(task1, task2));
        assertFalse(rule.areSyntacticallyEqual(task1, task2));
        assertFalse(rule.areSemanticallyEqual(task1, task2));

        assertEquals(TaskEquality.UNEQUAL, rule.compare(task2, task1));
        assertFalse(rule.areLexicallyEqual(task2, task1));
        assertFalse(rule.areSyntacticallyEqual(task2, task1));
        assertFalse(rule.areSemanticallyEqual(task2, task1));
    }


    /**
     *
     */
    @Test
    public void test_compare_05() {
        EventTaskComparisonRule rule = new EventTaskComparisonRule();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        ITask task1 = createNewEventTask(eventType1, eventTarget1);
        
        IEventType eventType2 = new StringEventType("eventType2");
        IEventTarget eventTarget2 = new DummyGUIElement("elem2");
        ITask task2 = createNewEventTask(eventType2, eventTarget2);
        
        assertEquals(TaskEquality.UNEQUAL, rule.compare(task1, task2));
        assertFalse(rule.areLexicallyEqual(task1, task2));
        assertFalse(rule.areSyntacticallyEqual(task1, task2));
        assertFalse(rule.areSemanticallyEqual(task1, task2));

        assertEquals(TaskEquality.UNEQUAL, rule.compare(task2, task1));
        assertFalse(rule.areLexicallyEqual(task2, task1));
        assertFalse(rule.areSyntacticallyEqual(task2, task1));
        assertFalse(rule.areSemanticallyEqual(task2, task1));
    }


    /**
     *
     */
    @Test
    public void test_compare_06() {
        EventTaskComparisonRule rule = new EventTaskComparisonRule();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        ITask task1 = createNewEventTask(eventType1, eventTarget1);
        
        assertEquals(TaskEquality.LEXICALLY_EQUAL,
                     rule.compare(task1.getInstances().iterator().next(),
                                  task1.getInstances().iterator().next()));
        assertTrue(rule.areLexicallyEqual(task1.getInstances().iterator().next(),
                                          task1.getInstances().iterator().next()));
        assertTrue(rule.areSyntacticallyEqual(task1.getInstances().iterator().next(),
                                              task1.getInstances().iterator().next()));
        assertTrue(rule.areSemanticallyEqual(task1.getInstances().iterator().next(),
                                             task1.getInstances().iterator().next()));
    }
    
    /**
     *
     */
    @Test
    public void test_compare_07() {
        EventTaskComparisonRule rule = new EventTaskComparisonRule();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        ITask task1 = createNewEventTask(eventType1, eventTarget1);
        
        ITask task2 = createNewEventTask(eventType1, eventTarget1);
        
        assertEquals(TaskEquality.LEXICALLY_EQUAL,
                     rule.compare(task1.getInstances().iterator().next(),
                                  task2.getInstances().iterator().next()));
        assertTrue(rule.areLexicallyEqual(task1.getInstances().iterator().next(),
                                          task2.getInstances().iterator().next()));
        assertTrue(rule.areSyntacticallyEqual(task1.getInstances().iterator().next(),
                                              task2.getInstances().iterator().next()));
        assertTrue(rule.areSemanticallyEqual(task1.getInstances().iterator().next(),
                                             task2.getInstances().iterator().next()));

        assertEquals(TaskEquality.LEXICALLY_EQUAL,
                     rule.compare(task2.getInstances().iterator().next(),
                                  task1.getInstances().iterator().next()));
        assertTrue(rule.areLexicallyEqual(task2.getInstances().iterator().next(),
                                          task1.getInstances().iterator().next()));
        assertTrue(rule.areSyntacticallyEqual(task2.getInstances().iterator().next(),
                                              task1.getInstances().iterator().next()));
        assertTrue(rule.areSemanticallyEqual(task2.getInstances().iterator().next(),
                                             task1.getInstances().iterator().next()));
    }

    /**
     *
     */
    @Test
    public void test_compare_08() {
        EventTaskComparisonRule rule = new EventTaskComparisonRule();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        ITask task1 = createNewEventTask(eventType1, eventTarget1);
        
        IEventType eventType2 = new StringEventType("eventType2");
        ITask task2 = createNewEventTask(eventType2, eventTarget1);
        
        assertEquals(TaskEquality.UNEQUAL,
                     rule.compare(task1.getInstances().iterator().next(),
                                  task2.getInstances().iterator().next()));
        assertFalse(rule.areLexicallyEqual(task1.getInstances().iterator().next(),
                                           task2.getInstances().iterator().next()));
        assertFalse(rule.areSyntacticallyEqual(task1.getInstances().iterator().next(),
                                               task2.getInstances().iterator().next()));
        assertFalse(rule.areSemanticallyEqual(task1.getInstances().iterator().next(),
                                              task2.getInstances().iterator().next()));

        assertEquals(TaskEquality.UNEQUAL,
                     rule.compare(task2.getInstances().iterator().next(),
                                  task1.getInstances().iterator().next()));
        assertFalse(rule.areLexicallyEqual(task2.getInstances().iterator().next(),
                                           task1.getInstances().iterator().next()));
        assertFalse(rule.areSyntacticallyEqual(task2.getInstances().iterator().next(),
                                               task1.getInstances().iterator().next()));
        assertFalse(rule.areSemanticallyEqual(task2.getInstances().iterator().next(),
                                              task1.getInstances().iterator().next()));
    }

    /**
     *
     */
    @Test
    public void test_compare_09() {
        EventTaskComparisonRule rule = new EventTaskComparisonRule();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        ITask task1 = createNewEventTask(eventType1, eventTarget1);
        
        IEventTarget eventTarget2 = new DummyGUIElement("elem2");
        ITask task2 = createNewEventTask(eventType1, eventTarget2);
        
        assertEquals(TaskEquality.UNEQUAL,
                     rule.compare(task1.getInstances().iterator().next(),
                                  task2.getInstances().iterator().next()));
        assertFalse(rule.areLexicallyEqual(task1.getInstances().iterator().next(),
                                           task2.getInstances().iterator().next()));
        assertFalse(rule.areSyntacticallyEqual(task1.getInstances().iterator().next(),
                                               task2.getInstances().iterator().next()));
        assertFalse(rule.areSemanticallyEqual(task1.getInstances().iterator().next(),
                                              task2.getInstances().iterator().next()));

        assertEquals(TaskEquality.UNEQUAL,
                     rule.compare(task2.getInstances().iterator().next(),
                                  task1.getInstances().iterator().next()));
        assertFalse(rule.areLexicallyEqual(task2.getInstances().iterator().next(),
                                           task1.getInstances().iterator().next()));
        assertFalse(rule.areSyntacticallyEqual(task2.getInstances().iterator().next(),
                                               task1.getInstances().iterator().next()));
        assertFalse(rule.areSemanticallyEqual(task2.getInstances().iterator().next(),
                                              task1.getInstances().iterator().next()));
    }


    /**
     *
     */
    @Test
    public void test_compare_10() {
        EventTaskComparisonRule rule = new EventTaskComparisonRule();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        ITask task1 = createNewEventTask(eventType1, eventTarget1);
        
        IEventType eventType2 = new StringEventType("eventType2");
        IEventTarget eventTarget2 = new DummyGUIElement("elem2");
        ITask task2 = createNewEventTask(eventType2, eventTarget2);
        
        assertEquals(TaskEquality.UNEQUAL,
                     rule.compare(task1.getInstances().iterator().next(),
                                  task2.getInstances().iterator().next()));
        assertFalse(rule.areLexicallyEqual(task1.getInstances().iterator().next(),
                                           task2.getInstances().iterator().next()));
        assertFalse(rule.areSyntacticallyEqual(task1.getInstances().iterator().next(),
                                               task2.getInstances().iterator().next()));
        assertFalse(rule.areSemanticallyEqual(task1.getInstances().iterator().next(),
                                              task2.getInstances().iterator().next()));

        assertEquals(TaskEquality.UNEQUAL,
                     rule.compare(task2.getInstances().iterator().next(),
                                  task1.getInstances().iterator().next()));
        assertFalse(rule.areLexicallyEqual(task2.getInstances().iterator().next(),
                                           task1.getInstances().iterator().next()));
        assertFalse(rule.areSyntacticallyEqual(task2.getInstances().iterator().next(),
                                               task1.getInstances().iterator().next()));
        assertFalse(rule.areSemanticallyEqual(task2.getInstances().iterator().next(),
                                              task1.getInstances().iterator().next()));
    }

}
