#!/bin/sh
#   Copyright 2012 Georg-August-Universit�t G�ttingen, Germany
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.



# This script starts the autoquest-htmlmonitor which is in the same folder as
# this script

# Absolute path to this script, e.g. /home/user/bin/foo.sh
SCRIPT=$(readlink -f $0)

# Find the autoquest-htmlmonitor JAR-File and start in the Folder of this Script
JAR_FILE=`find $(dirname $SCRIPT) -type f -name 'autoquest-htmlmonitor-*.jar'`

# Get the ProcessID of the autoquest-htmlmonitor which is in the same folder as this script
PID=$(ps ax | grep "$JAR_FILE" | grep -v ' grep ' | awk '{print $1 " " $7}')


# Check if this autoquest-htmlmonitor is already running
if [ ! -z "$PID" ]; then
  echo "autoquest-htmlmonitor is running with PID:$PID"
  exit 1
fi



HOME_DIR=`dirname $0`

# Given the "java" executable as an argument, find JAVA_HOME
find_java() {
  # First check if it is a JDK in the /usr/lib/jvm directory, or a symlink there.
  # The test is somewhat complicated due to the different ways the Java implementations
  # are set up with the alternatives system
  # e.g.
  #  /usr/bin/java -> /etc/alternatives/java -> /usr/lib/jvm/java-1.5.0-sun/jre/bin/java
  # or
  #  /usr/bin/java -> /etc/alternatives/java -> /usr/lib/jvm/java-gcj/bin/java -> /usr/bin/gij-4.2

  JAVA_HOME=$1
  while true ; do
    case $JAVA_HOME in
      /usr/lib/jvm/*)
        # Found it! Return the correct paremt directory.

        JAVA_HOME=`echo $JAVA_HOME | sed 's:\(/usr/lib/jvm/[^/]*\).*:\1:'`
	return
	;;
      *) ;;
    esac

    if [ -h $JAVA_HOME ] ; then
      JAVA_HOME=`readlink $JAVA_HOME`
    else
      break
    fi
  done
        
  # Not found in the Debian alternatives system, so presumably
  # it is a user-installed JDK/JRE. Might as well be helpful
  # and try to find JAVA_HOME.

  # First try for a JDK:
  JAVA_HOME=`readlink -e $1`
  while [ `dirname $JAVA_HOME` != /  ]; do
    if [ -e $JAVA_HOME/lib/tools.jar ]; then
      return
    fi

    JAVA_HOME=`dirname $JAVA_HOME`
  done

  # If we get here we did not find a JDK. Search again for a JRE:
  JAVA_HOME=`readlink -e $1`
  while [ `dirname $JAVA_HOME` != /  ]; do
    if [ -e $JAVA_HOME/bin/java ]; then
      return
    fi

    JAVA_HOME=`dirname $JAVA_HOME`
  done

  # Nothing found; leave blank
  JAVA_HOME=
}

if [ -z "$JAVA_HOME" ] ; then
  if [ -r /etc/gentoo-release ] ; then
    JAVA_HOME=`java-config --jre-home`
  else
    # Debian patch - search for preferred JRE
    if [ -n "$JAVACMD" ] ; then
      find_java "$JAVACMD"
    else
      find_java `which java`
    fi
  fi
fi

if [ -z "$JAVACMD" ] ; then
  if [ -n "$JAVA_HOME"  ] ; then
    if [ -x "$JAVA_HOME/jre/sh/java" ] ; then
      # IBM's JDK on AIX uses strange locations for the executables
      JAVACMD="$JAVA_HOME/jre/sh/java"
    else
      JAVACMD="$JAVA_HOME/bin/java"
    fi
  else
    JAVACMD="`which java`"
  fi
fi

if [ ! -x "$JAVACMD" ] ; then
  echo "Error: JAVA_HOME is not defined correctly."
  echo "  We cannot execute $JAVACMD"
  exit 1
fi

if [ -z "$JAVA_HOME" ] ; then
  echo "Warning: JAVA_HOME environment variable is not set."
fi

cd ${HOME_DIR}


if [ ! -f "$JAR_FILE" ] ; then
  echo "Error: Could not find executable jar file in distribution."
  echo "  Execution aborted."
  exit 1
fi

# If the logdir was given to the script: Use it but test if it exist
# if not, create it
if [ ! -z "$1" ] ; then
  LOGDIR="$1"
  if [ -d "$LOGDIR" ] ; then
    echo "Using LogDir $LOGDIR"
  else
    echo "Creating Folder $LOGDIR"
    mkdir "$LOGDIR"
  fi
else
  # ./log is the standard log file. If this folder does not exist
  # create it
  if [ ! -d "./log" ] ; then
     mkdir "./log"
  fi
  LOGDIR="./log"
  echo "Using LogDir ./log"
fi


# Every output from the JAR File will be saved in the Console.log
# &1 is stdout, &2 is stderr
echo "Starting autoquest-htmlmonitor"
exec 3>&1 4>&2 >>"$LOGDIR"/console.log 2>&1

echo ""
echo "starting HTML monitor"
date
echo "using java $JAVACMD"

$JAVACMD -jar ${JAR_FILE} $LOGDIR $2 2>&1 >> "$LOGDIR"/console.log &

# restore stdout and stderr
exec 1>&3 2>&4
