//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.eventcore.guimodel;

import java.io.Serializable;

import de.ugoe.cs.autoquest.eventcore.IEventTargetSpec;

/**
 * <p>
 * Common interface for GUI element specifications.
 * </p>
 * 
 * @version 1.1
 * @author Patrick Harms, Steffen Herbold
 */
public interface IGUIElementSpec extends Serializable, IEventTargetSpec {

    /**
     * <p>
     * Returns a string representation of the GUI element type that this specification represents.
     * </p>
     * 
     * @return
     */
    public String getType();
    
    /**
     * <p>
     * Returns a string array with the names of the classes in the hierarchy of the GUI element that
     * this specification represents. The first element is the GUI element's class, the second its
     * parent, the third its grand-parent, etc.
     * </p>
     * <p>
     * In case the class hierarchy is unknown or the GUI elements are not based on
     * object-orientation, this method should <code>return new String[]{getType()};</code>.
     * </p>
     * 
     * @return
     */
    public String[] getTypeHierarchy();

}
