//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.taskequality;

import java.util.Collection;

import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.eventcore.gui.Scroll;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTaskInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstance;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Patrick Harms
 */
public class InefficientActionsComparisonRule implements TaskComparisonRule {
    
    /* (non-Javadoc)
     * @see TaskComparisonRule#isApplicable(ITask, ITask)
     */
    @Override
    public boolean isApplicable(ITask task1, ITask task2) {
        if ((task1 instanceof IEventTask) && (task2 instanceof IEventTask)) {
            IEventTaskInstance instance1 =
                (IEventTaskInstance) task1.getInstances().iterator().next();
            
            IEventTaskInstance instance2 =
                (IEventTaskInstance) task2.getInstances().iterator().next();
            
            return isApplicable(instance1, instance2);
        }
        else {
            return false;
        }
    }

    /* (non-Javadoc)
     * @see TaskComparisonRule#areLexicallyEqual(ITask, ITask)
     */
    @Override
    public boolean areLexicallyEqual(ITask task1, ITask task2) {
        Collection<ITaskInstance> taskInstances1 = task1.getInstances();
        Collection<ITaskInstance> taskInstances2 = task2.getInstances();
        
        for (ITaskInstance instance1 : taskInstances1) {
            boolean found = false;
            
            for (ITaskInstance instance2 : taskInstances2) {
                if (areLexicallyEqual(instance1, instance2)) {
                    found = true;
                    break;
                }
            }
            
            if (!found) {
                return false;
            }
        }
        
        return true;
    }

    /* (non-Javadoc)
     * @see TaskComparisonRule#areSyntacticallyEqual(ITask, ITask)
     */
    @Override
    public boolean areSyntacticallyEqual(ITask task1, ITask task2) {
        return areLexicallyEqual(task1, task2);
    }

    /* (non-Javadoc)
     * @see TaskComparisonRule#areSemanticallyEqual(ITask, ITask)
     */
    @Override
    public boolean areSemanticallyEqual(ITask task1, ITask task2) {
        return areLexicallyEqual(task1, task2);
    }

    /* (non-Javadoc)
     * @see TaskComparisonRule#compare(ITask, ITask)
     */
    @Override
    public TaskEquality compare(ITask task1, ITask task2) {
        if (areLexicallyEqual(task1, task2)) {
            return TaskEquality.LEXICALLY_EQUAL;
        }
        else {
            return TaskEquality.UNEQUAL;
        }
    }

    
    /* (non-Javadoc)
     * @see TaskComparisonRule#isApplicable(ITaskInstance, ITaskInstance)
     */
    @Override
    public boolean isApplicable(ITaskInstance instance1, ITaskInstance instance2) {
        return
            (instance1 instanceof IEventTaskInstance) &&
            (instance2 instanceof IEventTaskInstance) &&
            (isInefficientAction(((IEventTaskInstance) instance1).getEvent())) &&
            (isInefficientAction(((IEventTaskInstance) instance2).getEvent()));
    }

    /* (non-Javadoc)
     * @see TaskComparisonRule#areLexicallyEqual(ITaskInstance, ITaskInstance)
     */
    @Override
    public boolean areLexicallyEqual(ITaskInstance instance1, ITaskInstance instance2) {
        return 
            (isInefficientAction(((IEventTaskInstance) instance1).getEvent())) &&
            (isInefficientAction(((IEventTaskInstance) instance2).getEvent()));
    }

    /* (non-Javadoc)
     * @see TaskComparisonRule#areSyntacticallyEqual(ITaskInstance, ITaskInstance)
     */
    @Override
    public boolean areSyntacticallyEqual(ITaskInstance instance1, ITaskInstance instance2) {
        return areLexicallyEqual(instance1, instance2);
    }

    /* (non-Javadoc)
     * @see TaskComparisonRule#areSemanticallyEqual(ITaskInstance, ITaskInstance)
     */
    @Override
    public boolean areSemanticallyEqual(ITaskInstance instance1, ITaskInstance instance2) {
        return areLexicallyEqual(instance1, instance2);
    }

    /* (non-Javadoc)
     * @see TaskComparisonRule#compare(ITaskInstance, ITaskInstance)
     */
    @Override
    public TaskEquality compare(ITaskInstance instance1, ITaskInstance instance2) {
        if (areLexicallyEqual(instance1, instance2)) {
            return TaskEquality.LEXICALLY_EQUAL;
        }
        else {
            return TaskEquality.UNEQUAL;
        }
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param event
     * @return
     */
    private boolean isInefficientAction(Event event) {
        return (event.getType() instanceof Scroll) ||
            ("headRotated".equals(event.getType().toString())) ||
            ("headMoved".equals(event.getType().toString()));
    }
}
