//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.mfc;

import org.xml.sax.SAXException;

import de.ugoe.cs.autoquest.eventcore.guimodel.GUIElementTree;

/**
 * <p>
 * Base class to define custom message handlers, for messages that shall be handled differently
 * during the parsing of usage logs. It provides dummy implementations for all required methods,
 * such that implementations can only overwrite the parts they actually require and ignore the rest.
 * </p>
 * 
 * @author Steffen Herbold
 * @author Fabian Glaser
 * @version 1.0
 */
public class MessageHandler {

    /**
     * <p>
     * during parsing, a tree of GUI elements is created and adapted.
     * This is the reference to it.
     * </p>
     */
    private GUIElementTree<Long> guiElementTree;

    /**
     * <p>
     * Constructor. Protected to prohibit initialization of the base class itself.
     * </p>
     * 
     * @param guiElementTree the tree of GUI element specifications to be created and adapted during
     *                   parsing
     */
    protected MessageHandler(GUIElementTree<Long> guiElementTree) {
        this.guiElementTree = guiElementTree;
    }

    /**
     * <p>
     * Called in the startElement() method of the {@link MFCLogParser} when a msg-node begins.
     * </p>
     */
    public void onStartElement() {}

    /**
     * <p>
     * Called by the {@link MFCLogParser} to handle param-nodes.
     * </p>
     * 
     * @param name
     *            name (type) of the parameter
     * @param value
     *            value of the parameter
     */
    public void onParameter(String name, String value) {}

    /**
     * <p>
     * Called in the endElement() method of {@link MFCLogParser} when a msg-node ends.
     * </p>
     * 
     * @throws SAXException if the msg-node could not be processed for some reason
     */
    public void onEndElement() throws SAXException {}

    /**
     * @return the gui element tree created and adapted during parsing
     */
    protected GUIElementTree<Long> getGUIElementTree() {
        return guiElementTree;
    }
    
}
