//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.genericeventmonitor;

/**
 * <p>
 * Exception to notify all irregularities, that are specific to the generic event monitor and its
 * components.
 * </p>
 * 
 * @author Patrick Harms
 */
class GenericEventMonitorException extends Exception {

    /**  */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * initializes an exception with a simple message
     * </p>
     *
     * @param message the message of the exception
     */
    GenericEventMonitorException(String message) {
        super(message);
    }

    /**
     * <p>
     * initializes an exception with a simple message and a causing exception
     * </p>
     *
     * @param message the message of the exception
     * @param cause   the root cause of the exception
     */
    GenericEventMonitorException(String message, Throwable cause) {
        super(message, cause);
    }

}
