/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.j3d.Bounds;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.SceneGraphCycleException;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Transform3D;

public abstract class Node
extends SceneGraphObject {
    public static final int ENABLE_PICK_REPORTING = 1;
    public static final int ENABLE_COLLISION_REPORTING = 0;
    public static final int ALLOW_BOUNDS_READ = 3;
    public static final int ALLOW_BOUNDS_WRITE = 4;
    public static final int ALLOW_PICKABLE_READ = 5;
    public static final int ALLOW_PICKABLE_WRITE = 6;
    public static final int ALLOW_COLLIDABLE_READ = 7;
    public static final int ALLOW_COLLIDABLE_WRITE = 8;
    public static final int ALLOW_AUTO_COMPUTE_BOUNDS_READ = 9;
    public static final int ALLOW_AUTO_COMPUTE_BOUNDS_WRITE = 10;
    public static final int ALLOW_LOCAL_TO_VWORLD_READ = 11;
    private boolean visited = false;

    public Node getParent() {
        if (this.isLiveOrCompiled()) {
            throw new RestrictedAccessException(J3dI18N.getString("Node0"));
        }
        NodeRetained nodeRetained = ((NodeRetained)this.retained).getParent();
        return nodeRetained == null ? null : (Node)nodeRetained.getSource();
    }

    public void setBounds(Bounds bounds) {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Node1"));
        }
        ((NodeRetained)this.retained).setBounds(bounds);
    }

    public Bounds getBounds() {
        if (this.isLiveOrCompiled()) {
            if (!this.getCapability(3)) {
                throw new CapabilityNotSetException(J3dI18N.getString("Node2"));
            }
        } else {
            this.checkForCycle();
        }
        return ((NodeRetained)this.retained).getBounds();
    }

    public boolean getCollidable() {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Node16"));
        }
        return ((NodeRetained)this.retained).getCollidable();
    }

    public void setCollidable(boolean bl) {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Node4"));
        }
        ((NodeRetained)this.retained).setCollidable(bl);
    }

    public void setBoundsAutoCompute(boolean bl) {
        if (this.isLiveOrCompiled() && !this.getCapability(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Node5"));
        }
        ((NodeRetained)this.retained).setBoundsAutoCompute(bl);
    }

    public boolean getBoundsAutoCompute() {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Node6"));
        }
        return ((NodeRetained)this.retained).getBoundsAutoCompute();
    }

    public void getLocalToVworld(Transform3D transform3D) {
        if (!this.isLive()) {
            throw new RestrictedAccessException(J3dI18N.getString("Node7"));
        }
        if (!this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Node8"));
        }
        ((NodeRetained)this.retained).getLocalToVworld(transform3D);
    }

    public void getLocalToVworld(SceneGraphPath sceneGraphPath, Transform3D transform3D) {
        if (!this.isLive()) {
            throw new RestrictedAccessException(J3dI18N.getString("Node7"));
        }
        if (!this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Node8"));
        }
        ((NodeRetained)this.retained).getLocalToVworld(sceneGraphPath, transform3D);
    }

    public Node cloneTree() {
        return this.cloneTree(new NodeReferenceTable(), false, false);
    }

    public Node cloneTree(boolean bl) {
        return this.cloneTree(new NodeReferenceTable(), bl, false);
    }

    public Node cloneTree(boolean bl, boolean bl2) {
        return this.cloneTree(new NodeReferenceTable(), bl, bl2);
    }

    public Node cloneTree(NodeReferenceTable nodeReferenceTable) {
        return this.cloneTree(nodeReferenceTable, false, false);
    }

    public Node cloneTree(NodeReferenceTable nodeReferenceTable, boolean bl) {
        return this.cloneTree(nodeReferenceTable, bl, false);
    }

    public Node cloneTree(NodeReferenceTable nodeReferenceTable, boolean bl, boolean bl2) {
        if (!this.isLiveOrCompiled()) {
            this.checkForCycle();
        }
        nodeReferenceTable.set(bl2, new Hashtable());
        Node node = this.cloneTree(bl, nodeReferenceTable.objectHashtable);
        Enumeration enumeration = nodeReferenceTable.objectHashtable.elements();
        while (enumeration.hasMoreElements()) {
            SceneGraphObject sceneGraphObject = (SceneGraphObject)enumeration.nextElement();
            sceneGraphObject.updateNodeReferences(nodeReferenceTable);
        }
        return node;
    }

    Node cloneTree(boolean bl, Hashtable hashtable) {
        Node node;
        this.nodeHashtable = hashtable;
        try {
            node = this.cloneNode(bl);
        }
        catch (RuntimeException runtimeException) {
            this.nodeHashtable = null;
            throw runtimeException;
        }
        this.nodeHashtable = null;
        hashtable.put(this, node);
        return node;
    }

    public Node cloneNode(boolean bl) {
        throw new RuntimeException(J3dI18N.getString("Node12"));
    }

    public void duplicateNode(Node node, boolean bl) {
        this.duplicateAttributes(node, bl);
    }

    final void checkDuplicateNode(Node node, boolean bl) {
        if (node.nodeHashtable != null) {
            this.duplicateAttributes(node, bl);
        } else {
            node.nodeHashtable = new Hashtable();
            this.duplicateAttributes(node, bl);
            node.nodeHashtable = null;
        }
    }

    void duplicateAttributes(Node node, boolean bl) {
        if (node.isLiveOrCompiled()) {
            throw new RestrictedAccessException(J3dI18N.getString("Node13"));
        }
        super.duplicateSceneGraphObject(node);
        NodeRetained nodeRetained = (NodeRetained)node.retained;
        NodeRetained nodeRetained2 = (NodeRetained)this.retained;
        nodeRetained2.setPickable(nodeRetained.getPickable());
        nodeRetained2.setCollidable(nodeRetained.getCollidable());
    }

    public void setPickable(boolean bl) {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Node14"));
        }
        ((NodeRetained)this.retained).setPickable(bl);
    }

    public boolean getPickable() {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Node3"));
        }
        return ((NodeRetained)this.retained).getPickable();
    }

    void checkForCycle() {
        if (this.visited) {
            throw new SceneGraphCycleException(J3dI18N.getString("Node15"));
        }
        this.visited = true;
        Node node = this.getParent();
        if (node != null) {
            node.checkForCycle();
        }
        this.visited = false;
    }
}

