/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BugReporterObserver;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.ba.MethodUnprofitableException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import javax.annotation.CheckForNull;

public class DelegatingBugReporter
implements BugReporter {
    private BugReporter delegate;

    public DelegatingBugReporter(BugReporter delegate) {
        this.delegate = delegate;
    }

    protected BugReporter getDelegate() {
        return this.delegate;
    }

    public void setErrorVerbosity(int level) {
        this.delegate.setErrorVerbosity(level);
    }

    public void setPriorityThreshold(int threshold) {
        this.delegate.setPriorityThreshold(threshold);
    }

    public void observeClass(ClassDescriptor classDescriptor) {
        this.delegate.observeClass(classDescriptor);
    }

    public void reportBug(BugInstance bugInstance) {
        this.delegate.reportBug(bugInstance);
    }

    public void logError(String message) {
        this.delegate.logError(message);
    }

    public void reportMissingClass(ClassNotFoundException ex) {
        this.delegate.reportMissingClass(ex);
    }

    public void reportMissingClass(ClassDescriptor classDescriptor) {
        this.delegate.reportMissingClass(classDescriptor);
    }

    public void finish() {
        this.delegate.finish();
    }

    public void reportQueuedErrors() {
        this.delegate.reportQueuedErrors();
    }

    public void addObserver(BugReporterObserver observer) {
        this.delegate.addObserver(observer);
    }

    public ProjectStats getProjectStats() {
        return this.delegate.getProjectStats();
    }

    public void logError(String message, Throwable e) {
        if (e instanceof MethodUnprofitableException) {
            return;
        }
        this.delegate.logError(message, e);
    }

    public void reportSkippedAnalysis(MethodDescriptor method) {
        this.delegate.reportSkippedAnalysis(method);
    }

    @CheckForNull
    public BugCollection getBugCollection() {
        return this.delegate.getBugCollection();
    }
}

