/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugAnnotationUtil;
import edu.umd.cs.findbugs.BugAnnotationVisitor;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FindBugsMessageFormat;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;
import java.util.HashSet;

public class IntAnnotation
implements BugAnnotation {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_ROLE = "INT_DEFAULT";
    private int value;
    private String description;
    public static final String INT_SYNC_PERCENT = "INT_SYNC_PERCENT";
    public static final String INT_OCCURRENCES = "INT_OCCURRENCES";
    public static final String INT_VALUE = "INT_VALUE";
    public static final String INT_SHIFT = "INT_SHIFT";
    public static final String INT_EXPECTED_ARGUMENTS = "INT_EXPECTED_ARGUMENTS";
    public static final String INT_ACTUAL_ARGUMENTS = "INT_ACTUAL_ARGUMENTS";
    public static final String INT_OBLIGATIONS_REMAINING = "INT_OBLIGATIONS_REMAINING";
    private static final String ELEMENT_NAME = "Int";

    public IntAnnotation(int value) {
        this.value = value;
        this.description = DEFAULT_ROLE;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int getValue() {
        return this.value;
    }

    public void accept(BugAnnotationVisitor visitor) {
        visitor.visitIntAnnotation(this);
    }

    public String format(String key, ClassAnnotation primaryClass) {
        if (key.equals("hash")) {
            if (this.isSignificant()) {
                return Integer.toString(this.value);
            }
            return "";
        }
        return IntAnnotation.getShortInteger(this.value);
    }

    public static String getShortInteger(int value) {
        String base16 = Integer.toHexString(value);
        int unique = IntAnnotation.uniqueDigits(base16);
        String base10 = Integer.toString(value);
        if (unique <= 3 && base16.length() - unique >= 3 && base10.length() > base16.length()) {
            return "0x" + base16;
        }
        return base10;
    }

    public static String getShortInteger(long value) {
        String base16 = Long.toHexString(value);
        int unique = IntAnnotation.uniqueDigits(base16);
        String base10 = Long.toString(value);
        if (unique <= 3 && base16.length() - unique >= 3 && base10.length() > base16.length()) {
            return "0x" + base16;
        }
        return base10;
    }

    private static int uniqueDigits(String value) {
        HashSet<Character> used = new HashSet<Character>();
        for (int i = 0; i < value.length(); ++i) {
            used.add(Character.valueOf(value.charAt(i)));
        }
        return used.size();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof IntAnnotation)) {
            return false;
        }
        return this.value == ((IntAnnotation)o).value;
    }

    public int compareTo(BugAnnotation o) {
        if (!(o instanceof IntAnnotation)) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        return this.value - ((IntAnnotation)o).value;
    }

    public String toString() {
        String pattern = I18N.instance().getAnnotationDescription(this.description);
        FindBugsMessageFormat format = new FindBugsMessageFormat(pattern);
        return format.format(new BugAnnotation[]{this}, null);
    }

    public void writeXML(XMLOutput xmlOutput) throws IOException {
        this.writeXML(xmlOutput, false, false);
    }

    public void writeXML(XMLOutput xmlOutput, boolean addMessages, boolean isPrimary) throws IOException {
        XMLAttributeList attributeList = new XMLAttributeList().addAttribute("value", String.valueOf(this.value));
        String role = this.getDescription();
        if (!role.equals(DEFAULT_ROLE)) {
            attributeList.addAttribute("role", role);
        }
        BugAnnotationUtil.writeXML(xmlOutput, ELEMENT_NAME, this, attributeList, addMessages);
    }

    public boolean isSignificant() {
        return !this.description.equals(INT_SYNC_PERCENT) && !this.description.equals(INT_OCCURRENCES);
    }

    public String toString(ClassAnnotation primaryClass) {
        return this.toString();
    }
}

